#ifndef SNAKEBODY_H
#define SNAKEBODY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include <vector>

/** SnakeBody:
@brief - Functions that exclusively control the snake body
@author Joseph Shotton
@date May 2020
@version V1.0
*/ 


class SnakeBody
{
struct Direction {
     int delta_x; // increment value for x          /**< x incrementation of the body in this state  */
     int delta_y; // increment value for y          /**< y incrementation of the body in this state  */
     int nextState[5];  // array of next states     /**< array of next states  */
    };

public:

    SnakeBody();
    ~SnakeBody();
    
    
     /** Initialises the body
    */
    void init();
    
    
     /** Adjusts the _length_increase variable so the snake's length gradually increases
    *@param The body units that the snake will eventually grow to
    */
    void add_length(int increase);
    
    
    /** Runs the appropriate functions for the body
    *@param Gamepad
    *@param LCD
    *@param _death is the flag for if there is a collision (in this case snake-snake)
    */
    void run(Gamepad &pad, N5110 &lcd, bool &_death); 
    
    
     /** Resets body variables so game can be replayed 
    */
    void reset();
    
    int head_x;
    int head_y;
    
    std::vector<int> body_x;
    std::vector<int> body_y;

private:
    
    
    /** Controls all movement functions
    *@param Gamepad
    */
    void snake_movement(Gamepad &pad);
    
    
    /** Draws body
    *@param LCD
    */
    void draw_body(N5110 &lcd);
    
    /** Detects snake-snake collision
    *@param Gamepad
    *@param _death  is the flag for if there is a collision (in this case snake-snake)
    */
    void snake_snake_collision(Gamepad &pad, bool &_death); 
    
    
    /** Updates direction of snake
    */
    void update_direction(); 
    
    
    /** Updates position of snake
    */
    void update_position(); 
    
    
    /** Updates body coordinates of whole snake
    */
    void update_body();
    
    float _angle;
    int _d;
    int _move_state;
    int _length;
    int _length_increase;
    
};
#endif