#ifndef SHOT_H
#define SHOT_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include <vector>
#include <time.h>
#include <stdlib.h>

/**struct of shot position type and direction*/
struct shot_posandtype {
    int x;
    int y;
    int type;
    int dir;
};

/** shot class
 *@brief set several kinds of shot and come from all around
 *@author Zeyu Feng
 *@13 April 2020
 */
class shot
{

public:

    /**constructor*/
    shot();
    /**destructor*/
    ~shot();
    /**generate first 7 shots vector include position type direction by iterating through the vector*/
    void init();
    
    /**produce a init position of shots((21,0);(42,0);(63,0);(21,45);(42,45);(63,45))
     *@param vector_i(shot_posandtype*)
     */
    void init_pos(shot_posandtype *i);
    
    /**update shots in their directions*/
    void update();
    
    /**resize shots as time goes on
       generate shots in empty vector */
    void update_shot();
    
    /**draw updated shots iterating through the vector*/
    void draw(N5110 &lcd);
    
    /**if beyoud border, delete it and generate new one, keep total number constant*/
    void delete_shot();
    
    /**control difficulty of game(size)
    *@param timerflag(int)
    *@param increment(float) per 1/6 s
    *@param max(int)
    */
    void gen_shot(int timer_flag, float increment, int max);

    /**accessors set the size of shots
    *@param size(int)
    */
    void set_size(int size);
    
    /**accessors create a shot vector for testing*/
    void set_shot(int x, int y, int type, int Direction);

    /**mutators get size
    *@return current size
    */
    int get_size();
    
    /** mutators get position of the shot for testing*/
    Vector2D get_shot();

private:
    /** creat vectors for my struct 'shot_posandtype'
        vector is useful as it is possible to remove or add elements*/
    std::vector<shot_posandtype> _p;
    
    /**vector size must an integer*/
    int _size;
    
    /**it's too fast to generate 1 shot per 1/6 second,
       generate a float number (0-1),use f_to_i convert to _size*/
    float _size_f;
    
    Vector2D _shot_pos;
};
#endif




