#include "shot.h"

int shots[4][3][3] = {
    {       {0,1,0},
            {1,1,1},
            {0,1,0},        },//shot type1
            
    {       {1,1,1},
            {0,1,1},
            {0,0,1},        },//shot type2
    
    {       {1,1,1},
            {0,1,0},
            {0,1,0},        },//shot type3
    
    {       {1,1,0},
            {1,1,0},
            {0,0,1},        }//shot type4
};

shot::shot()
{

}

shot::~shot()
{

}

void shot::init()
{

    _size = 7;
    _size_f = 7.0;
    _p.resize(_size);//initalises 7 shots vector
    srand(time(NULL));
    for (std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++) {
        init_pos(i);
        (*i).type = rand() % 4;//randomise initial type
        (*i).dir = rand() % 6;//randomise initial direction
    }

}

void shot::init_pos(shot_posandtype* i)
{

    int num_pos = rand() % 6;//randomise initial position
    if (num_pos == 0) {
        (*i).x = WIDTH/4;
        (*i).y = 0;
    }//top
    if (num_pos == 1) {
        (*i).x = WIDTH/2;
        (*i).y = 0;
    }//top
    if (num_pos == 2) {
        (*i).x = 3*WIDTH/4;
        (*i).y = 0;
    }//top
    if (num_pos == 3) {
        (*i).x = WIDTH/4;
        (*i).y = HEIGHT-3;
    }//bottom
    if (num_pos == 4) {
        (*i).x = WIDTH/2;
        (*i).y = HEIGHT-3;
    }//bottom
    if (num_pos == 5) {
        (*i).x = 3*WIDTH/4;
        (*i).y = HEIGHT-3;
    }//bottom

}

void shot::update()
{
    for (std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++) {
        if ((*i).dir == 0) {
            (*i).x +=1;
            (*i).y +=1;//SE
        } else if ((*i).dir == 1) {
            (*i).x +=0;
            (*i).y +=1;//S
        } else if ((*i).dir == 2) {
            (*i).x +=1;
            (*i).y -=1;//NE
        } else if ((*i).dir == 3) {
            (*i).x -=1;
            (*i).y -=1;//NW
        } else if ((*i).dir == 4) {
            (*i).x -=0;
            (*i).y -=1;//N
        } else if ((*i).dir == 5) {
            (*i).x -=1;    
            (*i).y +=1;//SW
        }
    }
}

void shot::update_shot()
{
    _p.resize(_size);
    for(std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++) {
        if(((*i).x == 0)&&((*i).y == 0)) {
            init_pos(i);
            (*i).type = rand() % 4;//randomise initial type
            (*i).dir = rand() % 6;//randomise initial direction
        }
    }
}

void shot::draw(N5110 &lcd)
{
    update();
    // delete invalid shots
    delete_shot();
    //generate shot to keep constant number of shots
    update_shot();
    for (std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++) {
        lcd.drawSprite((*i).x,(*i).y,3,3,(int*)shots[(*i).type]);
        //printf("coordinate = %d,%d\n",(*i).x,(*i).y);
    }
}

void shot::delete_shot()
{
    for (std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++) {
        // if beyoud border, delete it and generate new one, keep total number constant
        if(((*i).x < 0)||((*i).x > WIDTH)||((*i).y < 0)||((*i).y > HEIGHT)||
        //keep shots away from starting point
            (((*i).x==3)&&((*i).y==18))   ||   (((*i).x==4)&&((*i).y==28))||
            (((*i).x==79)&&((*i).y==16))  ||   (((*i).x==79)&&((*i).y==29)))  
        {
            init_pos(i);//generate new shots instead of those shots which beyoud border 
            (*i).type = ((*i).type + 2)%4;
            (*i).dir = ((*i).dir + 1)%6; // reset their type and dir (complex calculate to increase randomness)
        }
    }
}

/*  increment(number of shots is generated during 1000/6 ms)
    and maximum number of shots
    control degree of difficulty of the game*/
void shot::gen_shot(int timer_flag, float increment, int max)
{
    if(_size < max){
        if(timer_flag == 1){
            timer_flag = 0;
            _size_f = _size_f + increment;
            int size = int(_size_f);
            //printf("Generate\n");
            set_size(size);
        }
    }
}

void shot::set_size(int size) 
{
    _size = size;
}

void shot::set_shot(int x, int y, int type, int Direction)
{
    for (std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++){
        (*i).x = x;
        (*i).y = y;
        (*i).type = type;
        (*i).dir = Direction;
    }
}
int shot::get_size() 
{
    return _size;
}

Vector2D shot::get_shot()
{
    for (std::vector<shot_posandtype>::iterator i = _p.begin(); i < _p.end(); i++){
        _shot_pos.x =(*i).x;
        _shot_pos.y =(*i).y;
    }
    return _shot_pos;
}
        

 