#ifndef PEOPLEENGINE_H
#define PEOPLEENGINE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "People.h"

/** PeopleEngine class
@brief set a Engine of 'People' and do some basic check
@author Zeyu Feng
@12 April 2020
*/

class PeopleEngine
{
    
public:  
    /**constructor*/
    PeopleEngine();
    
    /**destructor*/
    ~PeopleEngine();
    
    /**initialize the position of people*/
    void init();
    
    /**read the polar input from Joystick*/
    void read_input(Gamepad &pad);
    
    /**update the position of people according to pad input(Joystick)*/
    void update();
    
    /**draw the basic element of game: box,start circle and destination circle and main object(people)
    *@param lcd
    *@param flag(int)
    */
    void draw(N5110 &lcd,int flag);
    /**mutators check whether the collision happens*/
    Vector2D get_pos();

private:

    People _people;//People class
    Direction _d;
    float _mag;
    Vector2D _p;
};
#endif
    

    