#include "People.h"
#define INIT_x 1
#define INIT_y 20

const int people_sprite[8][5] = {
        {0,1,1,1,0},
        {0,1,1,1,0},
        {0,0,1,0,0},
        {1,1,1,1,1},
        {0,0,1,0,0},
        {0,1,0,1,0},
        {0,1,0,1,0},
        {0,1,0,1,0},
};//try to draw a people, but for the operability of game, it seems not a good implementation..

const int running_people_sprite[8][5] = {
        {0,1,1,1,0},
        {0,1,1,1,0},
        {0,0,1,0,0},
        {1,1,1,1,1},
        {0,0,1,0,0},
        {0,1,0,1,0},
        {1,0,0,0,1},
        {1,0,0,0,1},
};

People::People() 
{
    
}

People::~People() 
{
    
}
    
void People::init() 
{    
    _x = INIT_x;
    _y = INIT_y;//Set initial postion of people
    _index = 0;
}

void People::draw(N5110 &lcd,int flag) 
{
    if(int(_mag*5)!=0&&flag!=0){
        if(!_index){
            lcd.drawSprite(_x,_y,8,5,(int*)people_sprite);//Draw sprite to represent a people
        // printf("drawSprite");
            _index = 1;
        }else{
            lcd.drawSprite(_x,_y,8,5,(int*)running_people_sprite);
            _index = 0;
        }
    }else{
        lcd.drawSprite(_x,_y,8,5,(int*)people_sprite);
    }      
}

/*control people by Joystick in different angle and magnitude
    */
void People::update()
{
    if(_d == S)        {
        _x += 0;            _y += int(_mag*5);
    } else if(_d == SE){
        _x += int(_mag*5);   _y += int(_mag*5);
    } else if(_d == E){
        _x += int(_mag*5);   _y += 0;
    } else if(_d == NE){
        _x += int(_mag*5);   _y -= int(_mag*5);
    } else if(_d == N){
        _x -= 0;            _y -= int(_mag*5);
    } else if(_d == NW){
        _x -= int(_mag*5);   _y -= int(_mag*5);
    } else if(_d == W){
        _x -= int(_mag*5);   _y -= 0;
    } else if(_d == SW){
        _x -= int(_mag*5);   _y += int(_mag*5);
    }
    //printf("Mag = %f,Direction = %d,Coordinate = %d, %d\n",_mag,_d,_x,_y);
    
    control_lim();//without going off screen
}

void People::control_lim()
{
    if (_x < 1) { _x = 1;}//left
    else if (_x > 78) { _x = 78;}//right
    else if (_y < 1) {_y = 1;}//top
    else if (_y > 41) {_y = 41;}//bottom
}

void People::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}

void People::set_velocity(Direction d,float mag)
{
    _d = d;
    _mag = mag;
}

Vector2D People::get_pos()
{
    Vector2D p = {_x,_y};
    //printf("Coord = %f,%f\n",p.x,p.y);
    return p;
}
 