#ifndef INSTRUCTION_H
#define INSTRUCTION_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** Instruction class
*@brief create a instruction interface for game
*@author Zeyu Feng
*@10 MAY 2020
*/

class Instruction{
    public:
        /** Constructor */
        Instruction();
        
        /** Destructor */
        ~Instruction();
        
        void init();
        
        /** draw instruction by a for loop
         *@param lcd @details N5110 obejct
         *@param pad @details Gamepad object
         */
        void draw(N5110 &lcd,Gamepad &pad);
        
    private:
        
        int _draw_flag;
        
        Direction _d;
        
};

#endif