#include "Instruction.h"

const char instruction [11][15] = {
    {"  Instruction "},
    {"--------------"},
    {"Move- Joystick"},
    {"--------------"},
    {"control 'peop-"},
    {"le' away from "},
    {"shots and rea-"},
    {"ch the destin-"},
    {"ation.        "},
    {"    Press B   "},
    {" back to menu "}
};

Instruction::Instruction()
{

}

Instruction::~Instruction()
{

}

void Instruction::init()
{
    _draw_flag = 0;
}

void Instruction::draw(N5110 &lcd, Gamepad &pad)
{
    init();
    pad.tone(10,0.05);
    pad.set_bpm(0);
    pad.reset_buttons();
    while (!pad.B_pressed()) {
        lcd.clear();
        _d = pad.get_direction();
        if(_d == N||_d ==NE||_d==NW) {
            _draw_flag = _draw_flag - 1;
        } else if(_d == S||_d==SE||_d==SW) {
            _draw_flag = _draw_flag + 1;
        }
        //
        if(_draw_flag < 0) {
            _draw_flag = 0;
        } else if(_draw_flag > 5)
            _draw_flag = 5;
    
        for(int i = 0; i < 6; i++)
            lcd.printString(instruction[_draw_flag + i],0,i);
        lcd.refresh();
        pad.leds_on();
        wait(0.25);
    }
}
