#ifndef COLLISION_H
#define COLLISION_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "PeopleEngine.h"
#include "shot.h"

/** Collision class
 *@brief check whether people is shotted
 *@author Zeyu Feng
 *@28 April 2020
 */
   
class Collision{
    
public:    
    /**constructor*/
    Collision();
    /**destructor*/
    ~Collision();
    
    /**init private variables*/
    void init();
    
    /**reset col_index to 0*/
    void reset_check_col();
    
    /**check whether there is a collision
    *@return whether collide
    */
    bool check(N5110 &lcd);
    
    /**check whether people reach destination
    *@return whether reach destination
    */
    bool check_des(N5110 &lcd);
    
    /**draw current health at the left top of lcd*/
    void draw(N5110 &lcd);
    
    /**draw basic elements in collision interface*/
    void draw_basic(N5110 &lcd);
    
    /**draw the collision interface to tell gamer health - 1*/
    void draw_collision(N5110 &lcd);
    
    /**accessors get health of people
    *@return health of people
    */
    int get_health();
    
    /**accessors get des_index
    *@return game information
    */
    int get_des();
    /**accessors get col_index
    *@return game information
    */
    bool get_check_col();
    
    /**accessors*/
    void set_pos(Vector2D pos);
    
private:
    
    int _health;
    int _check_col_index;
    int _check_des_index;
    
    Vector2D _people_pos;//starting coordinate
    
};
#endif
    
    
    


