#include "Collision.h"

const int heart_sprite[7][9] = {
    {0,1,1,0,0,0,1,1,0},
    {1,1,1,1,0,1,1,1,1},
    {1,1,1,1,1,1,1,1,1},
    {0,1,1,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,0,0},
    {0,0,0,1,1,1,0,0,0},
    {0,0,0,0,1,0,0,0,0},
};

Collision::Collision() 
{
    
}

Collision::~Collision() 
{

}

void Collision::init() 
{
    _health = 3;
    _check_col_index = 0;
    _check_des_index = 0;
}

void Collision::reset_check_col()
{
    _check_col_index = 0;
}

bool Collision::check(N5110 &lcd) 
{
    _check_col_index = 0;
    //check main part of people expect hands and foots(x,y+3)(x+4,y+3)(x,y+7)(x+4,y+7)
    if(lcd.getPixel(_people_pos.x+1,_people_pos.y)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+3,_people_pos.y)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+1,_people_pos.y+1)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+3,_people_pos.y+1)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+1,_people_pos.y+1)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+3,_people_pos.y+3)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+1,_people_pos.y+5)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+3,_people_pos.y+5)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x,_people_pos.y+6)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+4,_people_pos.y+6)) {  _check_col_index = 1; }
    if(lcd.getPixel(_people_pos.x+2,_people_pos.y+3)) {  _check_col_index = 1; }
    //printf("index = %d\n",_check_col_index);
    //printf("people_pos = %f,%f\n",_people_pos.x+2,_people_pos.y+3);
    if((_check_col_index == 1)&&(_health > 0)) { 
        //_check_col_index = 0;
        _health = _health - 1;
    }
    return _check_col_index;
    //printf("health is %d\n",_health);
}

//use a getPixel function to check whether 'People' reaches the destination
bool Collision::check_des(N5110 &lcd)
{
    _check_des_index = 0;
    if(lcd.getPixel(82,24)||lcd.getPixel(82,25)||lcd.getPixel(82,26)||
    lcd.getPixel(82,27)||lcd.getPixel(82,23)||lcd.getPixel(82,22)||
    lcd.getPixel(82,21)||lcd.getPixel(82,20)||lcd.getPixel(82,28)||
    lcd.getPixel(81,24)||lcd.getPixel(81,25)||lcd.getPixel(81,23))
    {
        _check_des_index = 1;
        //printf("reach des\n");
    }
    return _check_des_index;
}

//draw the health indicator at the top left corner
void Collision::draw(N5110 &lcd) 
{
    if(_health > 0)
        lcd.drawRect(1,1,_health*2,3,FILL_BLACK);
}

void Collision::draw_basic(N5110 &lcd)
{   
    lcd.printString("    HEALTH   ",0,1);
    lcd.drawRect(1,1,WIDTH-2,2,FILL_BLACK);
    lcd.drawRect(1,45,WIDTH-2,2,FILL_BLACK);
    lcd.drawRect(1,1,3,HEIGHT-2,FILL_BLACK);
    lcd.drawRect(80,1,3,HEIGHT-2,FILL_BLACK);
}

//draw a 1 second collision interface to clearly show the health decreases
void Collision::draw_collision(N5110 &lcd)
{
    lcd.clear();
    draw_basic(lcd);
    for(int i =0; i <get_health()+1;i++)
        lcd.drawSprite(18*i+20,24,7,9,(int*)heart_sprite);
    lcd.refresh();
    wait(1);

    lcd.clear();
    draw_basic(lcd);
    for(int i =0; i <get_health();i++)
        lcd.drawSprite(18*i+20,24,7,9,(int*)heart_sprite);
    lcd.refresh();
    wait(1);
}

int Collision::get_health() 
{
    return _health;
}

int Collision::get_des()
{
    return _check_des_index;
}

bool Collision::get_check_col()
{
    return _check_col_index;
}

void Collision::set_pos(Vector2D pos) 
{
    _people_pos = pos;
}
