#include "PeopleEngine.h"

PeopleEngine::PeopleEngine()
{

}

PeopleEngine::~PeopleEngine()
{
    
}

void PeopleEngine::init()
{
    _people.init();
}
void PeopleEngine::read_input(Gamepad &pad)
{
    //directions held in an enum and magnitude in polar coordinates
    _d = pad.get_direction();
    _mag = pad.get_mag();
    //printf("velocity = %d,%f\n",_d,_mag);
}
void PeopleEngine::update()
{
   _people.set_velocity(_d,_mag);
   _people.update();
   //_p=_people.get_pos();
   //printf("position = %f,%f\n",_p.x,_p.y);
}
   
void PeopleEngine::draw(N5110 &lcd,int flag)
{
    //lcd.clear();
    _people.draw(lcd,flag);
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT);//box of the game
    lcd.drawCircle(0,HEIGHT/2,7,FILL_TRANSPARENT);//destination
    lcd.drawCircle(WIDTH-1,HEIGHT/2,7,FILL_TRANSPARENT);//starting point
} 

Vector2D PeopleEngine::get_pos() 
{
    _p = _people.get_pos();
    return _p;
}