#ifndef PEOPLE_H
#define PEOPLE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** People class
@brief set a basic element of my project
@author Zeyu Feng
@9 April 2020
*/

class People {

public:
    /**Constructor*/
    People();
    
    /**Destructor*/    
    ~People(); 
    
    /**initialize the position of people*/
    void init();
    
    /**draw it on lcd and alternating type of people when running
    *@param lcd
    *@param type flag of people
    */
    void draw(N5110 &lcd,int flag);
    
    /**update the position of people*/
    void update();
    /** limit the people without going off screen*/
    void control_lim();
        
    /**accessors   set the position of people only for test
    *@param pos(Vector2D)
    */
    void set_pos(Vector2D p);
    /**accessors   control the people by Joystick
    *@param Direction (Direction)
    *@param Mag(float)
    */  
    void set_velocity(Direction d,float mag);//control by gamepad
        
    /**mutators get the position of people only for test
    *@return pos(Vector2D)
    */
    Vector2D get_pos();
       
private:
    Direction _d;
    float _mag;
    int _x;
    int _y;
    int _index;//choose the type of people
};
#endif
        