#ifndef PEOPLE_TEST_H
#define PEOPLE_TEST_H

/** PEOPEL(main object) test
 *@brief Check the initial position and whether people goes to correct position when moved 
 *@author Zeyu Feng
 *@date 10 May 2020
 *@returns true if all the tests passed
 */
 
bool People_test()
{
    //initialise people object 
    People people;
    people.init();
    
    //Set the postion to 10,10
    Vector2D initial_pos = {10,10};
    people.set_pos(initial_pos);
    
    //read initial position
    Vector2D pos_init = people.get_pos();
    
    //first test
    //set the velocity
    people.set_velocity(S,0.4);
    
    //update position(10,12)
    people.update();
    
    //read test position
    Vector2D pos_test1 = people.get_pos();
    //printf("test_pos1 = %f,%f\n",pos_test1.x,pos_test1.y);
    
    //second test
    people.set_velocity(NW,0.9);
    
    //update position(6,8)
    people.update();
    
    Vector2D pos_test2 = people.get_pos();
    //printf("test_pos2 = %f,%f\n",pos_test2.x,pos_test2.y);
    
    //Check the position
    bool success_flag = true;
    if (pos_init.x !=10|| pos_init.y!=10||
        pos_test1.x!=10||pos_test1.y!=12||
        pos_test2.x!=6 ||pos_test2.y!=8)
        success_flag = false;
        
    return success_flag;
}
#endif
    
    