#include  "Interface.h"

State fsm_5[5] = {
    {0,{4,1}},
    {1,{0,2}},
    {2,{1,3}},
    {3,{2,4}},
    {4,{3,0}}
};
// point to option
const int pointer[3][2] = {
    {1,0},
    {1,1},
    {1,0}
};

Interface::Interface()
{
    
}

Interface::~Interface()
{
    
}

void Interface::init()
{
    _menu_flag = 0;
    _defined_rate_flag = 0;
    _defined_max_flag = 0;
    _gameover_flag = 0;
    _count_down = 18;
    _victory_flag = 0;
    _sim_flag = 0;//simple game flag
}


void Interface::Welcome(N5110 &lcd,Gamepad &pad)
{
    // initialise record
    _record.x = 0;
    _record.y = 0;
    // start game after pressing the start botton
    while (!pad.start_pressed()) 
    {
        lcd.clear();
        lcd.printString("   Welcome!   ",0,1);
        lcd.printString("   Game by    ",0,2);
        lcd.printString("   Z. FENG    ",0,3);
        lcd.setContrast( pad.read_pot1());// control the contrast of screen
        lcd.drawRect(0,44,int(pad.read_pot1()*WIDTH),2,FILL_BLACK);// shows the contrast of gamepad by a black rectangle
        //printf("WIDTH of contrast = %d, contrast = %f\n",(int)pad.read_pot1()*WIDTH,pad.read_pot1());
        lcd.refresh();
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
    _sound.menu_sound(pad);
}

void Interface::menu(N5110 &lcd,Gamepad &pad)
{
    while (!pad.A_pressed())
    {
        lcd.clear();
        lcd.printString("     MENU",0,0);
        lcd.printString("        Start",0,1);
        lcd.printString("   Start(Hell)",0,2);
        lcd.printString("  user-defined",0,3);
        lcd.printString("   Instruction",0,4);
        lcd.printString("       Record",0,5);
        _d = pad.get_direction();
        // in order to easily control Joystick, pointer move upward in a large angle
        if(_d == N||_d ==NE||_d==NW){
            _menu_flag = fsm_5[_menu_flag].next_state[0];
        } else if(_d == S||_d==SE||_d==SW){
            _menu_flag = fsm_5[_menu_flag].next_state[1];
        }
        lcd.drawSprite(0,8*_menu_flag+10,3,2,(int*)pointer); 
        lcd.refresh();
        pad.leds_on();   
        wait(0.3);
        //printf("A_pressed\n");
    }
    _sound.begin_sound(pad);        
}

void Interface::undefined_rate(N5110 &lcd,Gamepad &pad)
{
    pad.tone(10,0.05);
    pad.set_bpm(0);
    pad.reset_buttons();
    while (!pad.A_pressed())
    {
        lcd.clear();
        lcd.printString("  shots/frames",0,0);
        lcd.printString("       0.3",0,1);
        lcd.printString("       0.4",0,2);
        lcd.printString("       0.5",0,3);
        lcd.printString("       0.6",0,4);
        lcd.printString("       0.7",0,5);
        _d = pad.get_direction();
        if(_d == N||_d ==NE||_d==NW){
            _defined_rate_flag = fsm_5[_defined_rate_flag].next_state[0];
        } else if(_d == S||_d==SE||_d==SW){
            _defined_rate_flag = fsm_5[_defined_rate_flag].next_state[1];
        }
        lcd.drawSprite(20,8*_defined_rate_flag+10,3,2,(int*)pointer); 
        lcd.refresh();
        pad.leds_on();   
        wait(0.3);
    }
}


void Interface::undefined_max(N5110 &lcd,Gamepad &pad)
{
    pad.reset_buttons();
    while (!pad.A_pressed())
    {
        lcd.clear();
        lcd.printString("   Max.shots",0,0);
        lcd.printString("       15",0,1);
        lcd.printString("       20",0,2);
        lcd.printString("       25",0,3);
        lcd.printString("       30",0,4);
        lcd.printString("       35",0,5);
        _d = pad.get_direction();
        if(_d == N||_d ==NE||_d==NW){
            _defined_max_flag = fsm_5[_defined_max_flag].next_state[0];
        } else if(_d == S||_d==SE||_d==SW){
            _defined_max_flag = fsm_5[_defined_max_flag].next_state[1];
        }
        lcd.drawSprite(20,8*_defined_max_flag+10,3,2,(int*)pointer); 
        lcd.refresh();
        pad.leds_on();   
        wait(0.3);
    }
    _sound.begin_sound(pad);
}


void Interface::game_over(N5110 &lcd,Gamepad &pad)
{
    _sound.over_sound(pad);
    lcd.clear();
    pad.init();
    while(!pad.B_pressed()){
        lcd.printString("  Game over   ",0,1);
        lcd.printString("  Press B to  ",0,2);
        lcd.printString("  try again?  ",0,3);
        lcd.refresh();
        wait(0.1);
        //printf("Not press B\n");
    }
    _gameover_flag = 1;
}

int Interface::check_pause(N5110 &lcd,Gamepad &pad,int paused_flag, float increment, int max)
{
    if(pad.start_pressed()){
        paused_flag = 1;
        sprintf(_buffer1,"  %.1f shots/s",increment*6);
        sprintf(_buffer2,"  with Max.%d ",max);
    }
        //printf("start press\n");
    while(paused_flag == 1){
        lcd.clear();
        _timer.stop();
        lcd.printString("Paused",23,0);
        lcd.printString(_buffer1,0,2);
        lcd.printString(_buffer2,0,3);
        lcd.refresh();
        if(pad.start_pressed())
            paused_flag = 0;
    }
    _timer.start();
    return paused_flag;
}

void Interface::count_down(N5110 &lcd)
{
    char buffer[6];
    sprintf(buffer,"%d",int(_count_down/6));
    lcd.printString(buffer,40,2);
    //printf("count: %d\n",_count_flag);
    _count_down--;
}

void Interface::update_record(float increment,int max)
{
    if(increment > _record.x||(int(increment)==int(_record.x)&& max > _record.y)){
        _record.x = increment;
        _record.y = max;
    }
}

void Interface::record(N5110 &lcd,Gamepad &pad)
{
    lcd.clear();
    pad.init();
    pad.tone(10,0.05);
    pad.set_bpm(0);
    sprintf(_buffer1,"  %.1f shots/s",_record.x*6);
    sprintf(_buffer2,"  with Max.%.0f ",_record.y);
    while(!pad.B_pressed()){
        lcd.printString("Record",23,0);
        lcd.printString(_buffer1,0,1);
        lcd.printString(_buffer2,0,2);
        lcd.printString(" Press B back ",0,4);
        lcd.printString("   to menu   ",0,5);
        lcd.refresh();
        wait(0.1);
    }
}

void Interface::victory(N5110 &lcd,Gamepad &pad)
{
    _sound.vict_sound(pad);
    lcd.clear();
    pad.init();
    while(!pad.B_pressed()){
        lcd.printString("   Victory!  ",0,1);
        lcd.printString(" Press B back ",0,2);
        lcd.printString("   to menu   ",0,3);
        lcd.refresh();
        wait(0.1);
    }
    _victory_flag = 1;
}

void Interface::simple_game(N5110 &lcd,Gamepad &pad)
{
    lcd.clear();
    pad.init();
    while(!pad.A_pressed()){
        lcd.printString("  DO YOU WANT ",0,1);
        lcd.printString(" MAKE IT EASY? ",0,2);
        lcd.printString("  PRESS A to",0,3);
        lcd.printString("  try again! ",0,4);
        lcd.refresh();
        wait(0.1); 
    }
    _sim_flag = 1;
    _sound.count_sound(pad);
}

void Interface::set_count_down(int count_down)
{
    _count_down = count_down;
}

int Interface::get_menu_flag()
{
    return _menu_flag;
}

int Interface::get_rate_flag()
{
    return _defined_rate_flag;
}

int Interface::get_max_flag()
{
    return _defined_max_flag;
}

int Interface::get_sim_flag()
{
    //printf("Get simple_flag %d\n",_sim_flag);
    return _sim_flag;
}

int Interface::get_gameover_flag()
{
     return _gameover_flag;
}

int Interface::get_victory_flag()
{
    return _victory_flag;
}
