/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Zeyu Feng
Username:el19zf
Student ID Number:201377605
Date:11/3/2020
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "People.h"
#include "PeopleEngine.h"
#include "shot.h"
#include "Collision.h"
#include "Interface.h"
#include "Instruction.h"
#include "tests.h"

// objects
Gamepad pad;
N5110 lcd;
PeopleEngine engine;
shot shot;
Collision collision;
Interface interface;
Sound sound;
Instruction instruction;

//flag and triggers
Ticker ticker;//gradually increase number of shots
Timeout timeout;
volatile int timer_flag = 0;
volatile int timeout_flag = 0;
volatile int paused_flag = 0;

//    prototypes
void flip(){    timer_flag = 1; }
void time_out(){    timeout_flag = 1;   }
void init();
void init_value();
void control_check();
void update(float, int);
void init_timeout();
void main_game(float,int);
void simp_game();
void undefined();

int main()
{
#ifdef WITH_TESTING
    int failures = run_all_tests();
#endif
    //initial
    init();
    
    interface.Welcome(lcd,pad);
    
    //a infinite loop 
    while(1) {
        init();
        init_value();
        //select option by Joystick
        interface.menu(lcd,pad);
        switch(interface.get_menu_flag()){
            case 0:
                main_game(0.15,13);
                break;
            case 1:
                main_game(1,35);
                simp_game();
                break;
            case 2:
            //define game parmeter by yourself
                undefined();
                break;
            case 3:
                instruction.draw(lcd,pad);
                break;
            case 4:
                interface.record(lcd,pad);
                break;
        }
        #ifdef DEBUG
            printf("END LOOP\n");
        #endif
    }
}

void main_game(float increment,int max){
    
    ticker.attach(&flip,2);//set a ticker
    timeout.attach(&time_out,3);//set a timeout
    
    while((collision.get_health() > 0)&&(!collision.get_des()))
    {   
        lcd.clear();
        //   increase shots with a ticker
        shot.gen_shot(timer_flag,increment,max);    
        //   shot update
        shot.draw(lcd);
        
        //   set a count down || generate and move the shots (shots won't move until count down to 0)
        //   check any collisions or victory
        update(increment, max);
        
        pad.leds_on();
        
        lcd.refresh();
        //printf("shot refresh\n");
        //printf("size = %d\n",shot._size);
        wait_ms(1000/6);//fps = 6
    }
    #ifdef DEBUG
        printf("END GAME\n");
    #endif
}

void init()
{
    lcd.init();
    engine.init();
    pad.init();
    shot.init();
    collision.init();
    lcd.refresh();
    interface.init();
}

void init_value()
{
    timer_flag = 0;
    timeout_flag = 0;
    paused_flag = 0;
}   

void control_check()
{
    //control the people by Joystick
    engine.read_input(pad);
    engine.update();
    collision.set_pos(engine.get_pos());
    // if people is shotted, health -1 and reset the game
    if(collision.check(lcd)) {
        pad.play_melody(2,sound_data_col,sound_dur_col,120,0);
        if(!collision.get_health()){
            interface.game_over(lcd,pad);
        } else{
            init_timeout();
        }
        lcd.clear();
    }
}

void update(float increment, int max)
{
    //if timeout_flag count down number and Joystick have been banned 
    if(timeout_flag){
        control_check();
        paused_flag = interface.check_pause(lcd,pad,paused_flag,increment,max);
    }else{
        interface.count_down(lcd);
        pad.reset_buttons();
    }
    //control people and check collision
    if(!collision.get_check_col()){
        engine.draw(lcd,timeout_flag);
        collision.draw(lcd);
    }else{
        collision.reset_check_col();
    }
    //check destination
    if(collision.check_des(lcd)){
        interface.victory(lcd,pad);
        interface.update_record(increment,max);
        lcd.clear();
    }
}

//reset timeout after collision (health > 0)
void init_timeout()
{   
    collision.draw_collision(lcd);
    engine.init();
    shot.init();
    //initialise timeout,flag and bottons
    timeout.attach(&time_out,3);
    timeout_flag = 0;
    interface.set_count_down(18);
    //count down, each duration 0.5s and 60 beats per minute(1s)
    sound.count_sound(pad);
    pad.reset_buttons();
    #ifdef DEBUG
        printf("initalises the timeout trigger\n");
    #endif
}

void simp_game()
{
    if(!interface.get_victory_flag()){
        
        interface.simple_game(lcd,pad);
        if(interface.get_sim_flag()){
            init();
            init_value();
            main_game(0.3,20);
        }
    }
    interface.init();
}

void undefined()
{
    //define shots rate and maximum
    interface.undefined_rate(lcd,pad);
    interface.undefined_max(lcd,pad);
    //   0   1   2   3   4  flag
    //  0.3 0.4 0.5 0.6 0.7 shots/frame
    //   15  20  25  30  35  Maximum shots
    main_game(0.1*(interface.get_rate_flag() + 3),5*(interface.get_max_flag()+ 3));
}
     