#ifndef INTERFACE_H
#define INTERFACE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Sound.h"

/**struct of fsm for menu option*/
struct State{
    int option;
    int next_state[2];
};

/** Interface class
*@brief welcome,meun,pause interface
*@author Zeyu Feng
*@10 MAY 2020
*/
class Interface {
    
public:
    
    /**Constructor*/
    Interface();
    
    /**Destructor*/
    ~Interface();
    
    /** initalises the flag varibales*/   
    void init();
        
    /** set a welcome interface for my game*/
    void Welcome(N5110 &lcd,Gamepad &pad);
        
    /** set an option menu*/
    void menu(N5110 &lcd,Gamepad &pad);
    
    /** set an user-defined menu*/
    void undefined_rate(N5110 &lcd,Gamepad &pad);
    
    /** set an user-defined menu*/
    void undefined_max(N5110 &lcd,Gamepad &pad);
        
    /** if health of people is zero, game over~*/
    void game_over(N5110 &lcd,Gamepad &pad);
        
    /** check pause for start botton*/
    int check_pause(N5110 &lcd,Gamepad &pad,int paused_flag,float increment,int max);
        
    /** count down and draw in lcd*/
    void count_down(N5110 &lcd);
    
    /** update record*/
    void update_record(float increment,int max);
    
    /** Record interface*/
    void record(N5110 &lcd,Gamepad &pad);
        
    /** Victory interface*/
    void victory(N5110 &lcd,Gamepad &pad);
    
    /** simple game interface*/
    void simple_game(N5110 &lcd,Gamepad &pad);
    
    /**accessors  set the count_down flag
    *@param count_down(int)
    */
    void set_count_down(int count_down);
    
    //mutators---------------------------
    
    int get_menu_flag();
    
    int get_rate_flag();
    
    int get_max_flag();
    
    int get_sim_flag();
    
    int get_gameover_flag();
    
    int get_victory_flag();

private:
    
    Sound _sound;
    Timer _timer;
    Direction _d;
    int _menu_flag;
    int _defined_rate_flag;
    int _defined_max_flag;
    int _sim_flag;
    int _gameover_flag;
    int _count_down;
    int _victory_flag;
    char _buffer1[14];
    char _buffer2[14];
    Vector2D _record;
    
};
#endif