#ifndef PREY_H
#define PREY_H

#include "mbed.h"
#include "LCD.h"
#include "Gamepad.h"
#include "Predator.h"

/** Prey Class
@author Maowei Yu, University of Leeds
@details the class  controls the prey component in the game 
@date May 2020
*/ 
class Prey
{

public:
    Prey();
    ~Prey();
    void init(int size,int speed);
    void draw(LCD &lcd);
    void update();
    /// accessors and mutators
    void set_velocity(POS2D v);
    POS2D get_velocity();
    POS2D get_pos();
    void set_pos(POS2D p);
    
private:

    POS2D _velocity;
    int _x;
    int _size;
    int _y;
};
#endif