#include "Prey.h"

Prey::Prey()
{

}

Prey::~Prey()
{

}

void Prey::init(int size,int speed)
{
    _size = size;

    _x = WIDTH/2 -  _size/2;
    _y = HEIGHT/2 - _size/2;

    srand(time(NULL));
    int direction = rand() % 4; // The initial direction for the prey is obtained randomly. 

    // 4 possibilities. Get random modulo and set velocities accordingly
    if (direction == 0) {
        _velocity.x = speed;
        _velocity.y = speed;
    } else if (direction == 1) {
        _velocity.x = speed;
        _velocity.y = -speed;
    } else if (direction == 2) {
        _velocity.x = speed;
        _velocity.y = speed;
    } else {
        _velocity.x = -speed;
        _velocity.y = -speed;
    }
}

void Prey::draw(LCD &lcd)
{
    lcd.drawRect(_x,_y,_size,_size,FILL_BLACK);
    

}

void Prey::update()
{
    _x += _velocity.x;
    _y += _velocity.y;
}

void Prey::set_velocity(POS2D v)
{
    _velocity.x = v.x;
    _velocity.y = v.y;
}

POS2D Prey::get_velocity()
{
    POS2D v = {_velocity.x,_velocity.y};
    return v;
}

POS2D Prey::get_pos()
{
    POS2D p = {_x,_y};
    return p;
}

void Prey::set_pos(POS2D p)
{
    _x = p.x;
    _y = p.y;
}