#include "Predator.h"

// blank constructor 
Predator::Predator()
{

}
//blank destructor
Predator::~Predator()
{

}

void Predator::init(int x,int radius)
{    _radius = radius;
    _x = WIDTH/2 - radius;  // x depends on width of the screen and height of predator
    _y = HEIGHT/2 - radius;  // y depends on height of screen and height of predator
    _speed = 1;  // default speed
    _point = 0;  // start the points from zero

}

    void Predator::draw(LCD &lcd)
{
    // draw predator in screen buffer. 
    lcd.drawCircle(_x,_y,_radius,FILL_BLACK);
    
}

void Predator::update(Direction pred,float mag)
{
    _speed = int(mag*10.0f);  // scale is arbitrary, could be changed in future

    // Update x and y values depending on the movement  direction
    // North is decrement as origin is at the top-left so decreasing moves up
    // West is decrement as origin is at the top-left so decreasing Left
    if (pred == N) {
        _y-=_speed;
    } else if (pred == S) {
        _y+=_speed;
    }
     else if (pred == W) {
        _x-=_speed;
    } else if (pred == E) {
        _x+=_speed;
    }

    // check the y origin to ensure that the predator doesn't go off screen
    if (_y < 1) {
        _y = 1;
    }
    if (_x < 1) {
        _x = 1;
    }
    if (_y > HEIGHT - _radius*2 - 1) {
        _y = HEIGHT - _radius*2 - 1;
    }
    if (_x> WIDTH - _radius*2 - 1) {
        _x = WIDTH - _radius*2 - 1;
    }
}

void Predator::add_points()
{
    _point++;
}
int Predator::get_points()
{
    return _point;
}

POS2D Predator::get_pos() {
    POS2D p = {_x,_y};
    return p;    
}