/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:yumaowei
Username:el19my
Student ID Number:201377547
Date:
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "LCD.h"
#include "HuntEngine.h"
#include "Predator.h"

#ifdef WITH_TESTING
# include "tests.h"
#endif


#define PREDATOR_RADIUS 4
#define PREY_SIZE 2
#define PREY_SPEED 3

/////////////// structs /////////////////
struct Inputparam {
    Direction predd;
    float mag;
};
/////////////// objects ///////////////
LCD lcd;
Gamepad player;
HuntEngine hunt;
Timer timeout;
Predator predator;

///////////// prototypes ///////////////
void init();
void update_game(Inputparam input);
void display();
void welcome();

///////////// functions ////////////////
int main()
{
#ifdef WITH_TESTING
    int number_of_failures = run_all_tests();

    if(number_of_failures > 0) return number_of_failures;
#endif

    int fps = 6;  // frames per second

    init();     // initialise and then display welcome screen...
    welcome();  // waiting for the user to start

    display();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period


    // game loop - read input, update the game state and render the display on LCD
    while (1) {
        hunt.read_input(player);
        hunt.update(player);
        display();
        wait(1.0f/fps);
    }
}
/* 
 * Function init:
 * Description: initialies all classes and libraries
 *  
 */

void init()
{
    // The lcd and the gamepad needs to be intialized first 
    lcd.init();
    player.init();
     
    // Then,initialise the game with correct prey and predator parameters
    hunt.init(PREDATOR_RADIUS,PREY_SIZE,PREY_SPEED);

}

/* 
 * Function display:
 * Description: This function draws each frame and component on the LCD
 *  @Brief it also clears,re-draw and refreshes screen
 */

void display()
{
    timeout.start();
    // clear screen, re-draw and refresh
    lcd.clear();  
    hunt.draw(lcd);
    lcd.refresh();
    while ( player.start_pressed() == true) {
        if (timeout.read() > 180000) {
      timeout.reset();
      if (predator.get_points() > 10) {
      lcd.printString(" WIN Game Over! ",10,10);
      lcd.printString(" SCORE ",10,8);  
       wait(2);
       lcd.refresh();
    }
    else {
      lcd.printString("FAILED! Game Over!",10,10);
      lcd.printString(" SCORE ",10,8);  
       wait(2);
       lcd.refresh();
    }
    player.start_pressed() == false;
    }
    }
}

// A default  splash screen that is displayed upon start-up of the device
void welcome() {
    
    lcd.printString("     Predator & Prey  Game   ",10,10);  
    lcd.printString("  Press Start ",10,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( player.start_pressed() == false) {
        lcd.setContrast( player.read_pot1());
        player.leds_on();
        wait(0.1);
        player.leds_off();
        wait(0.1);
    }
 
}
