#ifndef HUNTENGINE_H
#define HUNTENGINE_H

#include "mbed.h"
#include "LCD.h"
#include "Gamepad.h"
#include "Prey.h"
#include "Predator.h"

/** Prey Class
@author Maowei Yu, University of Leeds
@details This is the engine of predator_prey game.
@details the class  controls the prey and predator component in the game 
@date May 2020
*/ 
// gap from edge of screen
#define GAP 2

class HuntEngine
{

public:
    HuntEngine();
    ~HuntEngine();

    void init(int predator_radius,int prey_size,int speed);
    void read_input(Gamepad &pad);
    void update(Gamepad &pad);
    void draw(LCD &lcd);
    
private:

    void check_wall_collision(Gamepad &pad);
    void check_predator_collisions(Gamepad &pad);
    void check_catch(Gamepad &pad);
    void print_points(LCD &lcd);
    
    Predator _predator;
     
    int _predator_radius;
    int _prey_size;
    int _speed;
    
    // x positions of the predator
    int _px;
    
    
    Prey _prey;
    
    Direction _d;
    float _mag;

};

#endif