#ifndef BULLET_TEST_H
#define BUllET_TEST_H

/**
 * \brief Check that Ball object goes to correct position when moved
 * 
 * \returns true if all the tests passed
 */
bool Bullet_test_movement()
{
    // Initialise Bullet object with a size of 2, and speed of 1
    Bullet bullet;
    bullet.init(5, 5, 5, 5);

    // Set the position to 6,10
    Vector2D initial_position = {6,10};
    bullet.set_pos(initial_position);
    printf("%f, %f\n", set_pos.x, set_pos.y);

    
    // Read the position
    Vector2D read_position_1 = bullet.get_pos();
    printf("%f, %f\n", read_position_1.x, read_position_1.y);

    // Set the velocity to -1, 6
    Vector2D velocity = {-1, 6};
    bullet.set_velocity(velocity);

    // Update the position
    bullet.update();

    // Read the position
    Vector2D read_pos_2 = bullet.get_pos();
    printf("%f, %f\n", read_pos_2.x, read_pos_2.y);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x != 5 || read_pos_1.y != 16) {
        success_flag = false;
    }
    
    // Fail the test if the final position is wrong
    if (read_pos_2.x != 4 || read_pos_2.y != 22) {
        success_flag = false;
    }

    return success_flag;
}
#endif