#include "Touch.h"


//initialisation part
void Touch::init(int Board_width,int Board_length,int bullet_size,int speed,N5110 &lcd,int _board_y1,int _board_x1)
{
    // initialise the game parameters
    _Board_width = Board_width;         //width of board
    _Board_length = Board_length;       //length of board
    _bullet_size = bullet_size;         //bullet size
    _speed = speed;                     //speed
    _leds=0;                            //led number
    _board_x=_board_x1;
    _board_y=_board_y1;
    _board.init(_board_x,_board_y,_Board_length,_Board_width);     // draw board
    _bullet.init(_board_x,_bullet_size,_speed,_board_y);          //draw bullet
   
}

void Touch::reading(Gamepad &pad)
{
    _d = pad.get_direction();    // joystick direction
    _mag = pad.get_mag();        // joystick direction movement parameter
}

void Touch::draw(N5110 &lcd)
{
    lcd.drawRect(0,0,WIDTH,HEIGHT,FILL_TRANSPARENT); // draw a platform for game
    lcd.drawRect(0,20,84,4,FILL_BLACK); // score board
    print_scores(lcd);
    _board.draw(lcd);   // draw a board for game
    _bullet.draw(lcd);  // draw a bullet for game
}

void Touch::update(Gamepad &pad,N5110 &lcd)
{
    drop(pad);
    _board.update(_d,_mag);
    _bullet.update(lcd);

    Boundary_touch(pad);
    Board_touch(pad,lcd);
}

void Touch::Boundary_touch(Gamepad &pad)
{
    // read current ball attributes
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();

    // check if hit top wall
    if (bullet_pos.y <= 1) {  //  1 due to 1 pixel boundary
        bullet_pos.y = 1;  // bounce off ceiling without going off screen
        bullet_velocity.y = -bullet_velocity.y;
        // audio feedback
        pad.tone(750.0,0.1);
    }
    // check if hit right wall
    else if (bullet_pos.x+_bullet_size >= 83 ) { // right wall is 83
        // hit bottom
        bullet_pos.x = (WIDTH-1) - _bullet_size;  // stops ball going off screen
        bullet_velocity.x = -bullet_velocity.x;
        // audio feedback
        pad.tone(750.0,0.1);
    }// check if hit left wall
    else if (bullet_pos.x <= 1 ) { // left wall pixel is 1
        // hit bottom
        bullet_pos.x = 1;  // stops ball going off screen
        bullet_velocity.x = -bullet_velocity.x;
        // audio feedback
        pad.tone(750.0,0.1);
    }
    // update ball parameters
    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}

void Touch::Board_touch(Gamepad &pad,N5110 &lcd)
{
    Vector2D bullet_pos = _bullet.get_pos();
    Vector2D bullet_velocity = _bullet.get_velocity();
    Vector2D b_pos = _board.get_pos();
    if (
        (bullet_pos.x >= b_pos.x) &&                   //left
        (bullet_pos.x <= b_pos.x + _Board_length) &&   //right
        (bullet_pos.y+_bullet_size >=b_pos.y)&&        //down
        (bullet_pos.y-_Board_width<=b_pos.y)           //up
    ){
        
        // if it has, fix position and reflect x velocity
        _board.add_score();
        bullet_velocity.y = -bullet_velocity.y;     //fix position and reflect y velocity
        pad.tone(1000.0,0.1);         // audio effect as reminder
        
    }
    if((bullet_pos.y >= 0)&&(bullet_pos.y <= 24))
        {
            bullet_pos.y = bullet_pos.y + _Board_width;
            bullet_velocity.y = -bullet_velocity.y;

        }
    // write new datas
    _bullet.set_velocity(bullet_velocity);
    _bullet.set_pos(bullet_pos);
}

void Touch::drop(Gamepad &pad)
{
    Vector2D bullet_pos = _bullet.get_pos();
    if (bullet_pos.y + _bullet_size> 47) {
        _bullet.init(_board_x,_bullet_size,_speed,_board_y);
        _leds++;
        if(_leds>6)
         {  
            _leds=6;
        }
        pad.led(_leds,0);
        pad.tone(1500.0,0.5);
      //  pad.leds_on();
        wait(0.5);
     //   pad.leds_off();
    }
}

void Touch::print_scores(N5110 &lcd)
{
    // get scores from Boards
    int b_score = _board.get_score();

    // print to LCD i
    char buffer1[14];
    sprintf(buffer1,"Score is %2d",b_score);
    lcd.printString(buffer1,10,1); 
}