#ifndef TOUCH_H
#define TOUCH_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
#include "Board.h"

// gap from edge of screen
#define GAP 2
/** Touch Class
@author Chen Zirui, University of Leeds
@brief Interatcion between board and bullet and all boundaries from top left right and bottom
@date  May 2020
*/ 
class Touch
{

public:
    /**initialise board and bullet data*/
    void init(int Board_width,int Board_length,int bullet_size,int speed,N5110 &lcd);
    /**reading gamepad control*/
    void reading(Gamepad &pad);
    /**updating*/
    void update(Gamepad &pad,N5110 &lcd);
    /**drawing*/
    void draw(N5110 &lcd);
    /**led number*/
    int _leds;
    
private:
    /**Boundary touch judge*/
    void Boundary_touch(Gamepad &pad);
    /**Board touch judge*/
    void Board_touch(Gamepad &pad,N5110 &lcd);
    /**drop judge*/
    void drop(Gamepad &pad);
    /**print score*/
    void print_scores(N5110 &lcd);
    
    Board _board;
     
    int _Board_width;
    int _Board_length;
    int _bullet_size;
    int _speed;
    
    // x positions of the Boards
    int _board_x;
    int _board_y;
    int _p1y;
    //int _leds;
    float X;//[83];
    float Y;//[24];
    int s;
    Bullet _bullet;
    
    Direction _d;
    float _mag;

};

#endif