///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Touch.h"
#include "Bitmap.h"
#ifdef WITH_TESTING
# include "tests.h"
#endif

#define BOARD_WIDTH 2
#define BOARD_LENGTH 8
#define BULLET_SIZE 2
#define BULLET_SPEED 3

/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd;
Gamepad pad;
Touch touch;
///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();

///////////// functions ////////////////
int main()
{
#ifdef WITH_TESTING
    int number_of_failures = run_all_tests();
                                                //test part
    if(number_of_failures > 0) return number_of_failures;
#endif
    int fps = 6;                    // frames per second
    init();                         // initialise 
    welcome();                      // welcome screen for user to start
    render();                       // first draw the initial frame 
    wait(1.0f/fps);                 // and wait for one frame period
    pad.leds_on();                  //turn on all leds as 'lives' showing
    
    
    while (1)                       //while loop, execute reading, updating, drawing,juding part frequentrly
    {
        touch.reading(pad);
        touch.update(pad,lcd);
        render();
        if(touch._leds>=6)
         {  
            break;                  // if all lives finish , you will lsot game
         }
        wait(1.0f/fps);
    }
      lcd.init();
      pad.init();
      lcd.printString("   You fail   ",0,1);
      lcd.printString("  Press reset  ",0,4); // the reminder of game lost
      lcd.refresh();                 //function to refresh the display  
}

// initialies all classes and libraries
void init()
{
    lcd.init();
    pad.init();
    touch.init(BOARD_WIDTH,BOARD_LENGTH,BULLET_SIZE,BULLET_SPEED,lcd);
}
//clearing record before and drawing frames
void render()
{

    lcd.clear();  
    touch.draw(lcd);
    lcd.refresh();
}
//welcome screen
void welcome() {
    
    lcd.printString("     touch!    ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.start_pressed() == false) {
        lcd.setContrast( pad.read_pot1());
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}
