#ifndef PADDLECONTROL_H
#define PADDLECONTROL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


class PaddleControl 
{
    public:
    
        void init(int y, int length, int height);
        void print_lcd(N5110 &lcd);
        void set_size(int length, int height);
        void set_speed(int speed);
        void update_direction(char direction);
        Vector2D get_position();
         
    private:
        
        int _height;
        int _length;
        int _x;
        int _y;
        int _speed;
};
#endif