
#include "PaddleControl.h"\

void PaddleControl::init(int y,int length,int height)
{
    _y = y;  
    _x = WIDTH/2 - length/2;  
    _height = height;
    _length = length;
    _speed = 1;  
}

void PaddleControl::print_lcd(N5110 &lcd)
{
    lcd.drawRect(_x,_y,_length,_height,FILL_BLACK);
}

void PaddleControl::update_direction(char direction)
{
    if (direction == 'R') {
        _x-=_speed;
    } else if (direction == 'L') {
        _x+=_speed;
    }

    if (_x < 1) {
        _x = 1;
    }
    if (_x > WIDTH - _length - 1) {
        _x = WIDTH - _length - 1;
    }
}

void PaddleControl::set_speed(int speed)
{
    _speed = speed;
}


Vector2D PaddleControl::get_position() 
{
    Vector2D p = {_x,_y};
    return p;    
}