#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Ball 
{
    public:
    
        void init(int radius, int height, int speed);
        void print_lcd(N5110 &lcd);
        void set_size(int radius);
        void set_position(int x, int y);
        void set_velocity(Vector2D velocity);
        void update_position();
        Vector2D get_position();
        Vector2D get_velocity();
   
    private:
    
        int _radius;
        int _x;
        int _y;
        Vector2D _velocity;
    
}
#endif