#include "Ball.h"

void Ball::init(int radius, int height, int speed)
{
    _radius = radius;

    _x = WIDTH/2 -  _radius;
    _y = height;

    srand(time(NULL));
    int direction = rand() % 2; // randomise initial direction. 

    // 4 possibilities. Get random modulo and set velocities accordingly
    if (direction == 0) {
        _velocity.x = speed;
        _velocity.y = speed;
    } else (direction == 1) {
        _velocity.x = -speed;
        _velocity.y = speed;
    } 
}

void Ball::print_lcd(N5110 &lcd)
{
    lcd.drawCircle(_x, _y, _radius, FILL_BLACK);
}

void Ball::set_size(int radius)
{
    _radius = radius;
}

void Ball::set_position(int x, int y)
{
    _x = x;
    _y = y;
}

void Ball::set_velocity(Vector2D velocity)
{
    _velocity.x = velocity.x;
    _velocity.y = velocity.y;
}

void Ball::update_position()
{
    _x += _velocity.x;
    _y += _velocity.y;
}

void Ball::get_position()
{
    Vector2D position = {_x, _y};
    return position;
}

void Ball:get_velocity()
{
    Vector2D velocity = {_velocity.x, _velocity.y};
    return velocity
}