#ifndef SQUASHLOGIC_H
#define SQUASHLOGIC_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ball.h"
#include "Racket.h"

// gap from edge of screen
#define GAP 2

class SquashLogic
{

public:
    SquashLogic();
    ~SquashLogic();

    void init(int racket_width,int racket_height,int ball_size,int speed);
    void read_input(Gamepad &pad);
    void update(Gamepad &pad);
    void draw(N5110 &lcd);
    
private:

    void check_wall_collision(Gamepad &pad);
    void check_racket_collisions(Gamepad &pad);
    void check_goal(Gamepad &pad);
    void print_scores(N5110 &lcd);
    
    Racket _player;
     
    int _racket_width;
    int _racket_height;
    int _ball_size;
    int _speed;
    
    // x positions of the paddles
    int _p1x;
    int _p1y;
    
    Ball _ball;
    
    Direction _d;
    float _mag;

};

#endif