/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Simon Thackray Atkinson
Username: el18s2a   
Student ID Number: 201255483
Date: 05/03/2020
*/

// pre-processor directives
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Bitmap.h"
#include "SnakeEngine.h"
#include "Snake.h"
#include "Apple.h"

#define APPLE_SIZE 2
#define SNAKE_SPEED 1
#define SNAKE_SCORE 0
#define SNAKE_SNAKEHEIGHT 5  // Keep these equal to give it a square
#define SNAKE_SNAKEWIDTH 5  // Keep these equal to give it a square


// structs 
struct UserInput {
    Direction d;
    float mag;
};


// objects
N5110 lcd;  // Conects to LCD Display which is 84x48 pixels and can have 5 lines of text each contain 14 characters
Gamepad pad; // Conects to rest of gamepad and allows access to LEDs, Controls, Sensors ect
SnakeEngine snake; // Holds the majority of the game code and engine


// prototypes t
void init(); // Needed to setup the game and make sure everything is turned on
void update_game(UserInput input);
void render(); // Needed to make the screen work and update each frame
void welcome(); // Displays the splash screen when the device turns on or is reset

// functions 
int main()    // Everything in main.cpp is contained in this 
{

    int fps = 6;  // How many Frames Per Second (FPS)

    init();     // Turns on LCD and PAD
    welcome();  // Welcome screen to be shown before the game starts
    
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // wait for one period


    // The game loop, this reads the input of the pad updates and and renders the frame each time. The game can be slowed down or sped up depending on the wait function
    while (1) {
        snake.read_input(pad);  
        snake.crash(pad, lcd);      
        render();
        wait(1.0f/fps);
    }
}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init(); // LCD turned on
    pad.init(); // GamePad turned on
    snake.init(APPLE_SIZE,SNAKE_SCORE, SNAKE_SPEED, SNAKE_SNAKEWIDTH, SNAKE_SNAKEHEIGHT); //Initiates the values based on what is on the top of this file
}

// this function draws each frame on the LCD
void render()
{
    // Each time we render we need to clear screen get the buffer and refresh
    lcd.clear();  
    snake.draw(lcd);
    lcd.refresh();
}

// Welcome Screen
void welcome() {
    pad.led(3,1);  // Only Show Green LEDS
    pad.led(6,1);  //       
    lcd.clear();
       lcd.clear(); // we need to clear the screen first
   lcd.printString("    Author   ",0,1);  
   lcd.printString("Simon Atkinson",0,2); 
   lcd.printString("   201255483  ",0,3); 
   lcd.printString(" Uni of Leeds ",0,4); 
   lcd.refresh(); // need to refresh display after setting pixels or writing strings
           wait(1.0); // we don't want this screen on long!
               lcd.clear();
    lcd.printString("  Welcome to  ",0,1);  
    lcd.printString("    Snake!   ",0,2); 
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
    lcd.clear();
    while ( pad.start_pressed() == false) { // Will keep in the welcome state until the start button is pressed then it will go onto the game!
     }
     
}  //end of main.cpp
