#ifndef SNAKEENGINE_H
#define SNAKEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Apple.h"
#include "Snake.h"
#include "Bitmap.h"

/** SnakeEngine Class File
* @brief This contains the core of the Game.
* @author Simon Atkinson
* @date June 2020
*/

// gap from edge of screen
#define GAP 2


class SnakeEngine
{

public:
    SnakeEngine();
    ~SnakeEngine();
    
    /**
    @pram The Initial setup of the of the game engine.
    */
    void init(int apple_size, int snake_speed, int snake_score, int snake_snakeheight, int snake_snakewidth);
    /**
    @pram Allows us to read from any of the inputs in the gamepad in this case its the Thumbstick on the left hand side which controls the snakes movement.
    */
    void read_input(Gamepad &pad);  
    /**
    @pram We are using this for collision dection. Currently it only detects when you crash into the wall. If a collision is detected the game is over.
    */    
    void crash(Gamepad &pad, N5110 &lcd); 
    /**
    @pram This is used to draw what you see on the LCD display
    */
    void draw(N5110 &lcd);         
    /**
    @pram The snake is DEAD :( Ends the game when the snake is dead and displays your score and instructions for restarting the game. 
    */
    void dead(N5110 &lcd, Gamepad &pad); // 
    /**
    @pram Deals with the snake eating the apple. Started but wasn't able to get to work. It should detect when you eat the apple, add to the score and spawn another apple and give a flash of the green LEDs to show that the apple has been eaten.
    */
    void eat(N5110 &lcd, Gamepad &pad); 


private:

    void print_score(N5110 &lcd);
    
    int sx;  //Snake X
    int sy;  //Snake Y
    int ax;  //Apple X
    int ay;  //Apple Y
    int _apple_size;  //Apple size is defined and taken from main.cpp
    int _snake_speed; //Stores the speed the snake goes
    int _snake_score; //Stores the score
    int _snake_snakeheight; // Snake Hight
    int _snake_snakewidth; // Snake Width
    bool _dead;
    
    Snake _s;   //Allows us to use the Snake 
    Apple _a;   //Allows us to use the Apple 
    Direction _d; //Direction
    float _mag;   //Magnitude
    


};

#endif