#include "SnakeEngine.h"

SnakeEngine::SnakeEngine()
{

}

SnakeEngine::~SnakeEngine()
{

}
void SnakeEngine::init(int apple_size, int snake_speed, int snake_score, int snake_snakeheight, int snake_snakewidth)  // Inital values of the SnakeEngine
{
    //Apple Functions
    _apple_size = apple_size;
    _a.init(_apple_size);                        //Allows access to the apple
    
    //Snake Functions
    snake_speed = snake_speed; 
    _snake_snakeheight = snake_snakeheight;
    _snake_snakewidth = snake_snakewidth;
    _s.init(sx, sy, _snake_score, _snake_speed, _snake_snakewidth, _snake_snakeheight); //Alows access to the snake
}

void SnakeEngine::read_input(Gamepad &pad)
{
    //Reads the input of the thumbstick for controlling the snake
    _d = pad.get_direction();
    _mag = pad.get_mag();
    
    // Only Show Yellow LEDS when in game
    // In this void as we have gamepad access
                 pad.led(2,1);  
                 pad.led(5,1);  
                 pad.led(3,0);  
                 pad.led(6,0);   
}


void SnakeEngine::crash(Gamepad &pad, N5110 &lcd)
{
         //For moving the snake depending on the position of the thumbstick
         Vector2D snakepos = _s.get_pos(); 
            _s.update(_d,_mag);
         
         // Collision with wall Secition having this on will make it so if the snake colides with the wall then the snake dies
         // If you want to have it so the walls are boundaries and not deadly comment this section out and uncomment the section in Snake.CPP
             if (snakepos.x<=0){   // If it colides with the left wall
                 _dead=true;         //This function     
                dead(lcd,pad);}      //Ends the Game
              if (snakepos.x>=84-_snake_snakewidth){  // The right wall
                 _dead=true;
                dead(lcd,pad);}  
               if (snakepos.y<=8){  // Set to 8 Due to the score being included
                 _dead=true;
                dead(lcd,pad);}                               
              if (snakepos.y>=48-_snake_snakeheight){  // The bottom wall
                 _dead=true;
                dead(lcd,pad);}  
          // End of Wall of Death Section!      
}

void SnakeEngine::draw(N5110 &lcd)
{
    // draw what should be displayed on the screen
    
    // Game Area this allows us space for a line of text to display score
    lcd.drawRect(0,8,WIDTH,HEIGHT-8,FILL_TRANSPARENT);      
   
    // Displays the score
    print_score(lcd);
    
    // Draws the game objects Apple and Snake
    _a.draw(lcd);  // Draws Apple
    _s.draw(lcd);  // Draws Snake
}

void SnakeEngine::eat(N5110 &lcd, Gamepad &pad)

{
  Vector2D apple_pos = _a.get_pos();  // Gets the position of the apple
  Vector2D snake_pos = _s.get_pos();  // Gets the position of the snake 
  
  // Meant to get the position of the food and the position of the snake and adds to score and spawns a new apple but doesn't seem to work :(
  
   if (
        (apple_pos.y >= snake_pos.y) &&                     
        (apple_pos.y <= snake_pos.y + _snake_snakewidth) && 
        (apple_pos.x >= snake_pos.y) && 
        (apple_pos.x <= snake_pos.y + _snake_snakeheight))
        
        {
    _s.add_score();
    apple_pos.x = (rand() % (WIDTH));        // Spawns the food in a random place
    apple_pos.y = (rand() % (HEIGHT)); 
    
          pad.led(3,1);               // Flashes the LEDS green
          pad.led(6,1);
          wait(0.5);
          pad.led(3,0);
          pad.led(6,0);
  }
  
}

void SnakeEngine::print_score(N5110 &lcd)
{
        //Everything to do with displaying the score
        int score = _s.get_score();
        char buffer[14];                                         // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14) max characters is 14 
        int ScoreLength = sprintf(buffer,"Score:%2d", score);     // 
        if (ScoreLength <= 14)                                    // Will only display if the buffer is less than 14 (Shouldn't be an issue here)
            lcd.printString(buffer,WIDTH/2-25,0);                // Puts the score in the center of the display
}


void SnakeEngine::dead(N5110 &lcd, Gamepad &pad)

{
while(_dead == true){
    lcd.clear(); 
     
     // Shows the Score when you are dead
     int score = _s.get_score();
        char buffer[14];                                         // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14) max characters is 14 
        int ScoreLength = sprintf(buffer,"Score:%2d", score);     // 
        if (ScoreLength <= 14)                                    // Will only display if the buffer is less than 14 (Shouldn't be an issue here)
            lcd.printString(buffer,WIDTH/2-25,0);                // Puts the score in the center of the display
 
    // Notifies that you are dead and how to play again
 
    lcd.printString(" You're Dead!  ",0,2);  
    lcd.printString("  Play Again?  ",0,3); 
    lcd.printString(" Press Restart ",0,4);
    
    //Turns the Red LEDS on
                 pad.led(2,0);  
                 pad.led(5,0);  
                 pad.led(1,1);  
                 pad.led(4,1);  
                 wait(0.4);
                 pad.led(1,0); // Makes the flash :) 
                 pad.led(4,0);
                 wait(0.4); 
    lcd.refresh();
    }
}