#ifndef Snake_H
#define Snake_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Snake Class File
* @brief Class containing the snake for the actual game.
* @author Simon Atkinson
* @date June 2020
*/

class Snake
{
public:

    Snake();
    ~Snake();
    /**
    @pram The Initial setup of the of the snake
    */
    void init(int _x, int _y, int score, int _speed, int snakeheight, int snakewidth); 
    /**
    @pram For drawing the snake on the screen allows the use of the LCD
    */
    void draw(N5110 &lcd); 
    /**
    @return Gets the direction from the thumbstick
    */
    void update(Direction d,float mag); 
    /**
    @pram Eating an apple will add to the score
    */
    void add_score();
    /**
    @return Gives us the score
    */
    int get_score();
    /**
    @return Gets the position of the snake
    */
    Vector2D get_pos(); 
    /**
    @return Gets the value the determines how fast the snake moves
    */
    Vector2D get_move(); 
    /**
    @return Gets the direction the snake travels in can be only North, East, South or West and the snake can't move in other directions.
    */
    Vector2D get_Direction(); 
    /**
    @pram Sets the Movement of the snake
    */
    void set_move(Vector2D m);



private:

    Vector2D _move;  //Move value
    Vector2D _d;     // Direction
    int _x;          // X position of snake
    int _y;          // Y Position of snake
    int _score;      // Scoring system
    int _speed;      // Speed the snake goes
    int _snakeheight;      // set in main.cpp
    int _snakewidth;      // set in main.cpp


};
#endif