#ifndef APPLE_H
#define APPLE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** Apple Class File
* @brief Class containing the apple that the snake uses to get score and increase in size.
* @author Simon Atkinson
* @date June 2020
*/


class Apple

{
public:

    Apple();
    ~Apple();
    /**
    @pram The Initial setup of the of the apple
    */
    void init(int size); 
    /**
    @pram Draws the Apple on the LCD
    */
    void draw(N5110 &lcd);
    /**
    @return Gives us position data
    */    
    Vector2D get_pos();  
    /**
    @pram Sets the Position
    */
    void set_pos(Vector2D a); // 

private:

    int _x;  // X Value of Apple
    int _y;  // Y Value of Apple
    int _size; //Size set in main.cpp

};
#endif