/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Ruby Smith
Username: el18rs
Student ID Number: 201259470
Date: 22/05/20
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "TetrisGame.h"

// set defaults
#define TETROMINO_WIDTH 4
#define TETROMINO_HEIGHT 4
// #define TETROMINO_SIZE 4
#define SPEED 1
#define HEIGHT 48
#define WIDTH 84
// STRUCTS //

struct UserInput {
    Direction d;
    float mag;
};
// variables //

volatile extern int iH;
volatile extern int iB;

// OBJECTS //

N5110 lcd;
Gamepad pad;
TetrisGame tetris;

// PROTOTBPES //

void init();
void update_game(UserInput input);
void render();
void welcome();
void fallenblocks(N5110 &lcd, int iH);
void clearline(N5110 &lcd, int iB);
void set_values();

// FUNCTIONS //

int main()
{
    int fps = 6; // 6 frames per second

    init(); // initialise and display welcome screen
    welcome(); // wait for user to press start

    render(); // draw initial frame
    wait(1.0f/fps); // wait one frame period

    set_values();

// game loop
    while(1) {
        tetris.floor_hit_flag = 0;
        tetris.read_input(pad); // read input
        tetris.update(pad, lcd);
        lcd.refresh();
        lcd.clear();
        tetris.fallenblocks(lcd, iH);
        tetris.clearline(lcd, iB);
        tetris.draw(lcd); // re-draw
        if (tetris.floor_hit_flag==1) {
            tetris.fallenblocks(lcd, iH); // draw on old blocks
            iH++;
            tetris.X[iH] = tetris.a;
            tetris.Y[iH] = tetris.b;
            tetris.floor_hit_flag = 0;
            printf("iH increased\n");
        } else if (tetris.clear_line_flag==1) { // clear line and drop screen down
            iB++;
            tetris.Z[iB] = tetris.c;
            tetris.Q[iB] = tetris.d;
            tetris.clear_line_flag==0;
            printf("iB increased\n");
        }
        wait(1.0f/fps); // wait one frame period
    }
}


// initialise classes and libraries
void init()
{
    lcd.init(); // initialise lcd
    pad.init(); // initialise Gamepad

    // initialise the game with correct tetromino sizes etc
    tetris.init(SPEED);

}

void set_values()
{
    for(int i=0; i<=50; i++) {
        tetris.X[i]=0;
        tetris.Y[i]=0;
    }
}

void render()   // draws each frame on the lcd
{

    lcd.clear(); // clear screen
    tetris.draw(lcd); // re-draw
    lcd.refresh(); // refresh screen

}

// welcome screen display
void welcome()
{

    lcd.printString(" ROOKIE TETRIS",0,1);
    lcd.printString("  Press Start   ",0,4);
    lcd.refresh();

    // flash LEDs until start button pressed
    while (pad.start_pressed() == false) {
        lcd.setContrast(pad.read_pot1());
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}
