#ifndef TETRISGAME_H
#define TETRISGAME_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Tetromino.h"

/** TetrisGame Class
* @brief Runs the game
* @author Ruby Smith
* @date May 2020
*/

class TetrisGame
{

public:
    /** Constructor */
    TetrisGame();
    /** Destructor */
    ~TetrisGame();

    void init(int speed);
    void read_input(Gamepad &pad);
    void update(Gamepad &pad, N5110 &lcd);
    void draw(N5110 &lcd);
    void fallenblocks(N5110 &lcd, int iH);
    void clearline(N5110 &lcd, int iB);
    void print_scores(N5110 &lcd);
    void check_score(Gamepad &pad);
    void currentscreen(N5110 &lcd);

//    private:

    void check_wall_collision(Gamepad &pad, N5110 &lcd);
    void check_tetromino_collisions(Gamepad &pad, N5110 &lcd);

    void cancel_line(N5110 &lcd);
    void exit_game(N5110 &lcd);

    // Tetromino _p1;

    int count;
    volatile int X[50];
    volatile int Y[50];
    volatile int Z[50];
    volatile int Q[50];
    volatile int floor_hit_flag;
    volatile int clear_line_flag;
    volatile int a;
    volatile int b;
    volatile int c;
    volatile int d;
    int _px;
    int _py;
    int x0;
    int y0;
    int z0;
    int q0;
    int _speed;
    int score;
    int buffer[84][48];
    char Sbuffer[14];

    Tetromino _tetromino;

    Direction _d;
    float _mag;
};

#endif