#ifndef TETROMINO_H
#define TETROMINO_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Tetromino Class
* @brief Creates Blocks to be moved on screen
* @author Ruby Smith
* @date May 2020
*/

class Tetromino
{
public:

    /** Constructor */
    Tetromino();
    /** Destructor */
    ~Tetromino();
    void init(int x, int y);
    void draw(N5110 &lcd);
    void update(Direction d, float mag);
    Vector2D get_pos();
    Vector2D get_velocity();

private:

    Vector2D _velocity;

    int _x;
    int _y;
    int _speed;

};
#endif