#include "TetrisGame.h"

volatile int iH;
volatile int iB;

TetrisGame::TetrisGame()
{

}

TetrisGame::~TetrisGame()
{

}


void TetrisGame::init(int speed)
{
    // initialise game parameters
    _px = 40;
    _py = 4;
    _speed = speed;
    score = 1;

    _tetromino.init(_px, _py); // puts tetromino in middle

//    printf("initiate(%i)\n",_speed);

}


void TetrisGame::read_input(Gamepad &pad) // read inputs
{
    _d = pad.get_direction();
    _mag = pad.get_mag();
}

void TetrisGame::draw(N5110 &lcd) // draw elements in lcd buffer
{


    lcd.drawRect(19, 4, 42, HEIGHT - 4, FILL_TRANSPARENT);

    print_scores(lcd);

    _tetromino.draw(lcd);



//    printf("draw (%i,%i)\n",_px,_py);

}

void TetrisGame::update(Gamepad &pad, N5110 &lcd) // update values
{

    _tetromino.update(_d,_mag);

    check_score(pad);

    check_wall_collision(pad, lcd); // check if block has collided with the floor
    check_tetromino_collisions(pad, lcd); // check if block has collided with an old block

//    printf("update (%i,%i,%i)\n",_px,_py,_d);
}


void TetrisGame::check_wall_collision(Gamepad &pad, N5110 &lcd) // check if block has hit floor
{
    Vector2D tetromino_pos = _tetromino.get_pos(); // get current positioning of block

    if (tetromino_pos.y + 4 >= (HEIGHT-1) ) { // if bottom of block is on bottom boundary

        tetromino_pos.y = (HEIGHT-1) - 4; // stop block

        pad.tone(750.0,0.1); // play tone

        score++;

        cancel_line(lcd); // check if row is full

        _tetromino.init(_px, _py); // drop new shame

        a = tetromino_pos.x; // save positions to be drawn on next screen
        b = tetromino_pos.y;

        floor_hit_flag = 1; // set flag so program knows to draw block on next screen

        if (b <= 4) { // if pattern reaches top of screen
            exit_game(lcd); // game over
        }

//        printf("floor hit!\n");

    }
//    printf("wall collision\n");
}

void TetrisGame::check_tetromino_collisions(Gamepad &pad, N5110 &lcd) // check if block has old block beneath it
{
    Vector2D tetromino_pos = _tetromino.get_pos(); // get current position of block

    if (
        (lcd.getPixel(tetromino_pos.x, tetromino_pos.y + 4) == 1) ||
        (lcd.getPixel(tetromino_pos.x + 1, tetromino_pos.y + 4) == 1) ||
        (lcd.getPixel(tetromino_pos.x + 2, tetromino_pos.y + 4) == 1) ||
        (lcd.getPixel(tetromino_pos.x + 3, tetromino_pos.y + 4) == 1) // if any of the 4 pixels directly below the block are black
    ) {

        pad.tone(1000.0,0.1); // play tone

        score++;

        cancel_line(lcd); // check if row is full

        _tetromino.init(_px, _py); // drop new block

        a = tetromino_pos.x; // save positioning of old block
        b = tetromino_pos.y;

        floor_hit_flag = 1; // set flag so program knows to draw block on next screen

        if (b <= 4) { // if pattern reaches top of screen
            exit_game(lcd); // game over
        }

//        printf("blocks stacked!\n");
    }
//    printf("tetromino collision\n");
}

void TetrisGame::cancel_line(N5110 &lcd) // check if row is full, if it is then delete line and drop pattern down
{
    for(int j=4; j<=46; j++) {
        for(int i=20; i<=60; i++) {
            if (lcd.getPixel(i,j)==0) { // if the pixel is empty the counting stops and exits loop (row is not full)
                count=0;
//                printf("line not full\n");
                break;
            } else if (lcd.getPixel(i,j)==1) { // if the pixel is full carries on counting
                count ++;
//                printf("counting... count=%i\n",count);
            }
            if (count==48) { // if gets to end of line
                count = 0;
                printf("line full\n");
//                lcd.drawRect(20,j,40,4,FILL_WHITE); // clear line
                c = j;
                d = i;
                clear_line_flag = 1;
                floor_hit_flag = 0;
//                printf("line canceled!\n");
            }
        }
    }
//    printf("cancel line\n");
}

void TetrisGame::exit_game(N5110 &lcd)
{
    lcd.clear();
    lcd.printString(" GAME OVER \n",0, 3);
    lcd.refresh();
    wait(10);
//    printf("game over!\n");
    lcd.clear();
    lcd.printString(" press RESET ",0,6);
    lcd.refresh();
//    printf("press reset!\n");
    exit(1.0);
}

void TetrisGame::fallenblocks(N5110 &lcd, int iH)
{
    for (int i=0; i<=iH; i++) {
        x0 = X[i];
        y0 = Y[i];
        lcd.drawRect(x0, y0, 4, 4, FILL_BLACK);
//        printf("block drawn\n");
    }
}

void TetrisGame::currentscreen(N5110 &lcd)
{
    for (int i=0; i<=83; i++) {
        for (int j=0; j<=47; j++) {
            if(lcd.getPixel(i,j)) { //if pixel is set
                buffer[i][j] = 1;
            } else { // pixel is clear
                buffer[i][j] = 0;
            }
        }
    }
}

void TetrisGame::clearline(N5110 &lcd, int iB)
{
    for (int i=0; i<=iB; i++) {
        z0 = Z[i];
        q0 = Q[i];
        lcd.drawRect(20, z0, 40, 4, FILL_WHITE); // clear rectagle over where the full row is
    }
    currentscreen(lcd);
    for (int x=20; x<=60; x++) {
        for (int y=c; y>=0; y--) { // screen above row that was removed
            if (buffer[x][y]) { // buffer of screen
                lcd.setPixel(x,y, false); // remove pixel
                lcd.setPixel(x,y+4); // replace with pixel above it
            }
        }
    }
}

void TetrisGame::print_scores(N5110 &lcd) // print score on screen
{
    char Sbuffer[14];
    int n, _score = score;
    n=sprintf (Sbuffer, "%d",_score);
//    printf ("[%s] is a string %d chars long\n",Sbuffer,n);
    lcd.printString(Sbuffer,65,3);
}

void TetrisGame::check_score(Gamepad &pad) // update scores
{
    if ( clear_line_flag == 1) {
        score+=10;
    }
}