#include "Swatter.h"

Swatter::Swatter() {}       //Constuctor
Swatter::~Swatter() {}      //Destructor

void Swatter::init(int x,int height,int width)  //initilises the swatter parameters
{
    _x = x;                                  //x-axis of swatter
    _y = HEIGHT - 10;                        //y-axis of swatter
    _height = height;                        //height
    _width = width;                          //width
    _speed = 1;                              //speed
}

void Swatter::draw(N5110 &lcd)              //draws the swatter
{
    const int swat[10][9] =  {              //The array for the swatter, 1=pixel turn on
        {1,1,1,1,1,1,1,1,1},
        {1,0,1,0,1,0,1,0,1},
        {1,1,0,1,0,1,0,1,1},
        {1,0,1,0,1,0,1,0,1},
        {1,1,0,1,0,1,0,1,1},
        {1,1,1,1,1,1,1,1,1},
        {0,0,0,0,1,0,0,0,0},
        {0,0,0,0,1,0,0,0,0},
        {0,0,0,0,1,0,0,0,0},
        {0,0,0,0,1,0,0,0,0},
    };
    lcd.drawSprite(_x,_y,10,9,(int *)swat); //draws the swatter
}
void Swatter::update(Direction d,float mag) //updates the direction of the swatter from the joystick movement
{
    _speed = int(mag*10.0f);                //sets the speeds
    if (d == E) {                           //if direction is east (right)
        _x+=_speed;                         //x-axis moves in positive direction
    } else if (d == W) {                    //but if direction is west (left)
        _x-=_speed;                         //x-axis moves in negative direction
    }
    if (_x < 1) {                           //stops the swatter moving off the left side of the screen
        _x = 1;
    }                                       //stops the swatter moving off the right side of the screen
    if (_x > 75) {
        _x = 75;
    }
}

Vector2D Swatter::get_pos()     //gets the swatter's actual position
{
    Vector2D p = {_x,_y};       
    return p;
}