/** Engine Class
* @brief Operates the game
* @author Rosemary Gillman
* @date April, 2020
*/
#ifndef ENGINE_H
#define ENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bug.h"
#include "Swatter.h"
#include "Splat.h"

class Engine
{
public:

    /** Constructor */
    Engine();
    
    /** Destructor */
    ~Engine();
    
    /** Set initalisation 
    * @param the value of the swatter width, swatter heigh and speed (int)
    */
    void init(int swatter_width,int swatter_height,int speed);
    
    /** Read the engine input
    * @return the values to the pad
    */
    void read_input(Gamepad &pad);
    
    /** Update the engine
    * @return the values to the pad and lcd
    */
    void update(N5110 & lcd, Gamepad & pad);
    
    /** Time the duration of gameplay
    * @return the start time
    */
    void timer();
    
    /** Draw the game
    * @return the values to the lcd
    */
    void draw(N5110 &lcd);
    
    /** Check side collisions
    * @return the values to the pad
    */
    void check_side_collision(Gamepad &pad);
    
    /** Check swatter/bug collisions
    * @return the values to the lcd/pad
    */
    void check_swatter_collisions(N5110 & lcd, Gamepad & pad);
    
    /** End the game
    * @return the values to the lcd/pad
    */
    void ending(N5110 & lcd, Gamepad & pad);

private:

    int height;                 //swatter height
    int width;                  //swatter width
    int x;                      //x-axis point
    int _speed;                 //bug speed
    int random_collision;       //sets the 
    
    float _mag;                 //magnitude

    clock_t start;              //start time
    clock_t clockTicksTaken;    //time value
    
    double timeInSeconds;       //time in seconds of game
    double duration;            //duration of game
    double final;               //final time
    
    Bug _bug;                   //identifying the bug
    Splat _splat;               //identifying the splat
    Swatter _swatter;           //identifying the swatter
    Direction _d;               //identifying the direction
    
    bool collisionX;            //X-axis collision
    bool collisionY;            //Y-axis collision
    
};
#endif
