#include "Bug.h"

Bug::Bug() {}       //Constuctor
Bug::~Bug() {}      //Destructor

void Bug::init(int speed)           //initilises the bug parameters
{
    _x = 50;                        //starts the bug at a x-axis of 50
    _y = 0;                         //starts the bug at a y-axis of 0
    _velocity.y = speed;            //sets the speed to the y-axis velocity
}

void Bug::draw(N5110 &lcd)          //draws the bug
{
    const int buggy[8][8] =  {      //The array for the bug, 1=pixel turn on
        {0,0,1,0,0,1,0,0},
        {0,1,0,1,1,0,1,0},
        {1,1,1,1,1,1,1,1},
        {0,0,1,1,1,1,0,0},
        {1,1,1,1,1,1,1,1},
        {0,0,1,1,1,1,0,0},
        {0,1,0,0,0,0,1,0},
        {1,0,0,0,0,0,0,1},
    };
    lcd.drawSprite(_x,_y,8,8,(int *)buggy); //draws the bug
}

void Bug::update()                  //updates the bug's velocity/direction
{
    _x += _velocity.x;              //updates the x-axis velocity
    _y += _velocity.y;              //updates the y-axis velocity
}

void Bug::set_velocity(Vector2D v)  //sets the bug's velocity
{
    _velocity.x = v.x;              //sets the x-axis velocity
    _velocity.y = v.y;              //sets the y-axis velocity
}

Vector2D Bug::get_velocity()        //gets the bug's actual velocity 
{
    Vector2D v = {_velocity.x,_velocity.y}; //actual bug velocity vector
    return v;                               //returns the vector value
}

Vector2D Bug::get_pos()             //gets the bug's actual position
{
    Vector2D p = {_x,_y};
    return p;
}

void Bug::set_pos(Vector2D p)       //sets the bug's position
{
    _x = p.x;
    _y = p.y;
}