/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Rosemary Gillman
Username: EL18RG
Student ID Number: 201265952
Date:20/03/20
*/

/** pre-processor directives */
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Swatter.h"
#include "Bug.h"
#include "Engine.h"

#define SWATTER_WIDTH 10
#define SWATTER_HEIGHT 9
#define BUG_SPEED 3

#ifdef TESTING
# include "tests.h"
#endif

/** objects */
Gamepad pad;
N5110 lcd;
Engine engine;

/** prototypes */
void first_init();
void start();
void play_game();

/** functions */
int main()
{
    #ifdef TESTING      //running tests
    int fails = run_all_tests();

    if(fails > 0) return nfails;
    #endif
    
    first_init();           //first initilisation
    engine.timer();         //starts the timer
    start();                //runs the start screen
    while (1) {                     //while start is pressed
        engine.read_input(pad);     //engine reads inputs
        engine.update(lcd, pad);    //engine updates
        pad.leds_off();             //turns the leds off
        play_game();                //starts the gameplay
        wait_ms(80);                //sets the fps
    }
}

void first_init()           //initilises the gamepad and screen
{
    lcd.init();             //initalises the lcd
    pad.init();             //initlaises the gamepad
    engine.init(SWATTER_WIDTH,SWATTER_HEIGHT,BUG_SPEED);    //initalises the engine with the input values        
}

void play_game()            //starts the game and timer
{
    lcd.clear();            //clears the lcd
    engine.draw(lcd);       //engine draws the gameplay
    lcd.refresh();          //refreshs the lcd
}

void start()                //displays the start screen
{
    lcd.printString("Bug Splat",15,2);      //lcd prints text
    lcd.printString("Leeds Edition",1,3);   //lcd prints text
    lcd.refresh();                          //lcd refreshes
    pad.tone(500.0,0.5);                    //low pad tone plays
    for (int i = 0; i < 5; i++) {           //for loop flashes the leds
        pad.leds_on();
        wait_ms(200);
        pad.leds_off();
        wait_ms(200);
    }
    pad.leds_off();                         //leds are turned off
    lcd.clear();                            //lcd is cleared
    lcd.refresh();                          //lcd is refreshed
    lcd.printString("Splat the bug",0,0);   //lcd prints text
    lcd.printString("as fast",0,1);         //lcd prints text
    lcd.printString("as you can!",0,2);     //lcd prints text
    lcd.printString("Press start",0,5);     //lcd prints text
    lcd.refresh();                          //lcd refreshes
    while ( pad.start_pressed() == false) { //when start is pressed lights turn off
        pad.leds_on();
    }
}
