/** Swatter Class
* @brief Operates and draws the swatter
* @author Rosemary Gillman
* @date April, 2020
*/
#ifndef SWATTER_H
#define SWATTER_H
 
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

class Swatter 
{
public:

    /** Constructor */
    Swatter();
    
    /** Destructor */
    ~Swatter();
    
    /** Set initalisation 
    * @param the value of the width, height and x (int)
    */
    void init(int x,int height,int width);
    
    /** Draw the swatter 
    * @return the swat on the lcd
    */
    void draw(N5110 &lcd);
    
    /** Update the swatter 
    * @param the value of the swatter direction and mag(nitude)
    */
    void update(Direction d,float mag);
    
    /** Get swatter vector position
    * @return the swatter position as a vector
    */
    Vector2D get_pos();

private: 
        
    int direction;  //swatter direction
    int _height;    //swatter hight
    int _width;     //swatter width
    int _x;         //x-axis of swatter
    int _y;         //y-axis of swatter
    int _speed;     //speed of swatter
    
};
#endif