#include "Engine.h"
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include <ctime>

Engine::Engine() {}     //Constuctor
Engine::~Engine() {}    //Destructor

void Engine::init(int swatter_width,int swatter_height,int speed) //initalises the game
{
    width = swatter_width;                          //set width
    height = swatter_height;                        //set hight
    _speed = speed;                                 //sets the speed
    x = 2;                                          //set x
    _swatter.init(x,height,width);                  //initialise the swatter with parameters
    _bug.init(_speed);                              //initilise the bug with speed
}

void Engine::read_input(Gamepad &pad)               //reads the direction and magnitude inputs
{
    _d = pad.get_direction();                       //gets the direction
    _mag = pad.get_mag();                           //gets the magnitude
}

void Engine::draw(N5110 &lcd)                       //draws the bug and swatter
{
    _bug.draw(lcd);                                 //draws the bug
    _swatter.draw(lcd);                             //draws the swatter
}

void Engine::update(N5110 & lcd, Gamepad & pad)     //updates the game
{
    _swatter.update(_d,_mag);                       //updates the swatter with direction/magnitude
    _bug.update();                                  //updates the bug
    check_side_collision(pad);                      //checks side/bug collision
    check_swatter_collisions(lcd, pad);             //checks swatter/bug collision
}
void Engine::check_side_collision(Gamepad &pad)     //checks if the bug collides with the sides and redirects it
{
    Vector2D bug_pos = _bug.get_pos();              //get the bug position
    Vector2D bug_velocity = _bug.get_velocity();    //get the bug velocity
    if (bug_pos.y <= 1) {                           //if the bug touches the top y-axis
        bug_pos.y = 1;                              //put the bug back inside the boundaries
        bug_velocity.y = -bug_velocity.y;           //reverse the y velocity
        bug_velocity.x = rand() % 5 + 0;            //bounce on the x-axis at a 0-5 random velocity
        pad.tone(750.0,0.1);                        //play a medium pad tone
    } else if (bug_pos.y + 10 >= (HEIGHT-1) ) {     //if the bug touches the bottom y-axis
        bug_pos.y = (HEIGHT-1) - 10;                //put the bug back inside the boundaries
        bug_velocity.y = -bug_velocity.y ;          //reverse the y velocity
        bug_velocity.x = rand() % 5 + 0;            //bounce on the x-axis at a 0-5 random velocity
        pad.tone(750.0,0.1);                        //play a medium pad tone
    }
    if (bug_pos.x <= 1) {                           //if the bug touches the left x-axis
        bug_pos.x = 1;                              //put the bug back inside the boundaries
        bug_velocity.x = -bug_velocity.x;           //reverse the x velocity
        bug_velocity.y = rand() % 5 + 0;            //bounce on the y-axis at a 0-5 random velocity
        pad.tone(750.0,0.1);                        //play a medium pad tone
    } else if (bug_pos.x + 10 >= (WIDTH-1) ) {      //if the bug touches the right x-axis
        bug_pos.x = (WIDTH-1) - 10;                 //put the bug back inside the boundaries
        bug_velocity.x = -bug_velocity.x ;          //reverse the x velocity
        bug_velocity.y = rand() % 5 + 0;            //bounce on the y-axis at a 0-5 random velocity
        pad.tone(750.0,0.1);                        //play a medium pad tone
    }

    _bug.set_velocity(bug_velocity);                //set the bug velocity
    _bug.set_pos(bug_pos);                          //set the bug position
}
void Engine::check_swatter_collisions(N5110 & lcd, Gamepad & pad)   //checks if the swatter and bug have collided
{
    Vector2D bug_pos = _bug.get_pos();                              //get bug position
    Vector2D p_pos = _swatter.get_pos();                            //get swatter position
    Vector2D bug_velocity = _bug.get_velocity();                    //get bug velocity
    
    if ((bug_pos.x <= (p_pos.x +5)) && (bug_pos.x +5 >= p_pos.x)) { //check for x-axis collision
        collisionX=true;
    } else {
        collisionX=false;
    }
    if ((bug_pos.y <= (p_pos.y+5)) && (bug_pos.y+5 >= p_pos.y )) {  //check for y-axis collision
        collisionY=true;
    } else {
        collisionY=false;
    }
    if (collisionX && collisionY) {                                 //if there's a x and y-axis collision
        ending(lcd, pad);                                           //run ending
    }
}
void Engine::timer()                                //starts the timer off
{
    start = clock();
}
void Engine::ending(N5110 & lcd, Gamepad & pad)     //runs end of the game sequence
{
    lcd.clear();                                    //clear lcd
    pad.leds_on();                                  //leds on
    pad.tone(500.0,0.5);                            //play low pad tone
    duration = clock() - start;                     //find duration of timer
    final = ((float)duration/CLOCKS_PER_SEC)/2;     //change duration into seconds (final)
    char buffer[1];                                 //create buffer
    sprintf(buffer,"%.2f",final);                   //write value to buffer
    for (double i = 0; i < 100000; i += 0.1) {      //for loop to keep the game stopped
        lcd.refresh();                              //refresh lcd
        lcd.printString(buffer,20,1);               //print time
        lcd.printString("secs",35,2);               //print text
        _splat.draw(lcd);                           //draw splats
    }
}