/** Bug Class
* @brief Operates and draws the bug
* @author Rosemary Gillman
* @date April, 2020
*/

#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class Bug
{
public:

    /** Constructor */
    Bug();
    
    /** Destructor */
    ~Bug();
    
    /** Initialise the bug
    * @param the value of the speed (int)
    */
    void init(int speed);
    
    /** Draw the bug
    * @return the value on the screen
    */
    void draw(N5110 &lcd);
    
    /** Update the bug
    * @return the updated point
    */
    void update();
    
    /** Set the bug velocity
    * @param the value of the get velocity vector
    */
    void set_velocity(Vector2D v);
    
    /** Set the bug position
    * @param the value of the position vector
    */
    void set_pos(Vector2D p);

    /** Get the velocity vector
    * @return the velocity vector value
    */
    Vector2D get_velocity();
    
    /** Get the position vector
    * @return the position vector vaue
    */
    Vector2D get_pos();

private:

    Vector2D _velocity;     //velocity vector
    
    int _x;                 //the x-axis value of the bug
    int _y;                 //the y-axis value of the bug
    
};
#endif