#include "Spaceship.h"

void Spaceship::turn_CW() {
    orientation -= turn_rate;
    //a variable turn rate makes the gameplay less repetitive
    
    if (orientation < 0) orientation += 6.2832f;
    else if (orientation >= 6.2832f)orientation -= 6.2832f;
}

void Spaceship::turn_CCW() {
    orientation += turn_rate;
    
    if (orientation >= 6.2832f) orientation -= 6.2832f;
    else if (orientation < 0) orientation += 6.2832f;
}

void Spaceship::accelerate() {
    v_x += acceleration * cos(orientation);
    v_y += acceleration * sin(orientation);
    //this function integrates acceleration into velocity in 2D
    
    while (sqrt(v_x * v_x + v_y * v_y) > top_speed) {
        v_x -= (v_x / abs(v_y + v_x)) * 0.5f * acceleration;
        v_y -= (v_y / abs(v_y + v_x)) * 0.5f * acceleration;
    }
    //this while loop makes turning more intuitive
    //by effectively rotating your heading when the top speed is reached 
}

void Spaceship::deccelerate() {
    v_x -= acceleration * cos(orientation);
    v_y -= acceleration * sin(orientation);
    
    while (sqrt(v_x * v_x + v_y * v_y) > top_speed) {
        v_x -= (v_x / abs(v_y + v_x)) * 0.5f * acceleration;
        v_y -= (v_y / abs(v_y + v_x)) * 0.5f * acceleration;
    }
    //entirely identical to accelerate() except direction
}

void Spaceship::update_position() {
    pos_x += v_x;
    pos_y += v_y;
    //this function integrates velocity to position
}

void Spaceship::machine_gun(float x, float y) {
    if (x == y && (clock() - reload_timer) > 15) {//this is the case for forward fire
        bullet[chamber][0] = pos_x + 3 * cos(orientation);
        bullet[chamber][1] = pos_y + 3 * sin(orientation);
        bullet[chamber][2] = cos(orientation) + v_x * 0.25f;
        bullet[chamber][3] = sin(orientation) + v_y * 0.25f;
        //storing the x and y velocity in an array is more efficient
        //than doing expensive calculations each frame
        
        chamber++;
        chamber = chamber % 5;
        //"chamber" limits the number of particles to 5
        reload_timer = clock();
        //"reload_timer" will be compared to clock
        //next time the function is called, to determine fire rate
        gun_FX = 1;
        //used to identify when the sound effect should play
    }
    else if ((clock() - reload_timer) > 30) {//this is the case for turret fire
        float angle =- atan(x / y) + 1.5708f;
        if (y > 0) angle += 3.1416f;
        bullet[chamber][0] = pos_x + 3 * cos(orientation);
        bullet[chamber][1] = pos_y + 3 * sin(orientation);
        bullet[chamber][2] = cos(orientation - angle) + v_x * 0.25f;
        bullet[chamber][3] = sin(orientation - angle) + v_y * 0.25f;
        //above adds the ship's velocity to the bullet, Physics!
        
        chamber++;
        chamber = chamber % 5;
        reload_timer = clock();
        gun_FX = 3;
        //a different sound effect
    }
}

void Spaceship::cannon() {
    //largely similar to machine_gun()
    //except fire rate and projectile speed
    if ((clock() - reload_timer) > 60) {
        bullet[chamber][0] = pos_x + 3 * cos(orientation);
        bullet[chamber][1] = pos_y + 3 * sin(orientation);
        bullet[chamber][2] = 0.7f * cos(orientation) + v_x * 0.25f;
        bullet[chamber][3] = 0.7f * sin(orientation) + v_y * 0.25f;
        
        chamber++;
        chamber = chamber % 5;
        reload_timer = clock();
        gun_FX = 3;
    }
}

void Spaceship::update_bullets() {
    //integrates velocity into position
    
    for (int inc2 = 0; inc2 < 5; inc2++) {
        bullet[inc2][0] += 4 * bullet[inc2][2];
        bullet[inc2][1] +=4 * bullet[inc2][3];
    }
}

void Spaceship::update() {
    //a public function that makes sure
    //both the ship and its particles update at once
    
    update_position();
    update_bullets();
}

void Spaceship::controls(bool player_ship_type, 
        bool Y, bool A, bool X, bool B, float x, float y) {
    //calls the private functions all at once
    //with instructions from main
    
    if (Y) turn_CW();
    if (A) turn_CCW();
    if (X) accelerate();
    if (B) deccelerate();
    if (abs(x) > 0.1f || abs(y) > 0.1f) {
        if (player_ship_type == 0) machine_gun(x, y);
        else cannon();
    }
#ifdef DEBUG_controls
        sprintf(g_buffer, "%1.1f,%1.1f", x, y);
        lcd.printString(g_buffer, 0, 4);
        printf("Joystick val: %1.1f,%1.1f\n", x, y);
#endif
    update();
}

void Spaceship::AI_controls(float target_x, float target_y, float target_orientation) {
    float diff_x = target_x - pos_x;
    if (abs(diff_x) < 0.001f) diff_x = 0.001f;
    
    float angle_to_target = atan((target_y - pos_y) / diff_x) + 3.1416f;
    if (diff_x > 0) angle_to_target += 3.1416f;
    
    float diff_angle = orientation - angle_to_target;
    if (diff_angle > 6.1831f) diff_angle -= 6.2831f;
    if (diff_angle < -6.1831f) diff_angle += 6.2831f;
    //above maths finds if a CW or CCW turn is needed
    //to point the enemy ships towards the player
    
    if (diff_angle > 0.10f && diff_angle < 3.25f || diff_angle < -3.25f) turn_CW();
    else if (diff_angle < -0.10 || diff_angle > 3.25f) turn_CCW();
    else if (sqrt((target_y - pos_y) * (target_y - pos_y) + diff_x * diff_x) < 40) {
        machine_gun(0,0);
    }
    //if no adjustment is needed, fire away
    
    accelerate();
    //always accelerating makes the enemies fly more naturally
    
    #ifdef DEBUG_AI
        sprintf(g_buffer, "%1.3f", diff_x);
        lcd.printString(g_buffer, 0, 4);
        sprintf(g_buffer, "%1.2f,%1.2f", pos_x, pos_y);
        lcd.printString(g_buffer, 0, 5);
        printf("Enemy position: %3.1f,%3.1f\n", pos_x, pos_y);
    #endif
}

void Spaceship::init_ship(float x, float y, float direction,
        float turn, float acc, float top, int health) {
    pos_x = x; pos_y = y; 
    v_x = 0; v_y= 0;
    
    if (x == 1 && y == 0) v_x = 0.1;//drft the player forwars, that looks cool
    acceleration = acc;
    orientation = direction;
    top_speed = top;
    turn_rate = turn;
    if (turn_rate > 0.10f) turn_rate = 0.10f;
    chamber = 0;
    reload_timer = 0;
    HP = health;
    explosion_FX = 8;
    // sets all ship parameters to the declaration from main
    
    for (int inc = 0; inc < 5; inc++) {
        bullet[inc][0] = 50;
        bullet[inc][1] = 50;
        bullet[inc][2] = 4;
        bullet[inc][3] = 4;
    }
    // make sure the projectiles are at known positions
    // and won't appear on screen
}

bool Spaceship::check_bullets(int temp1, int temp2) {
    for (int inc1 = 0; inc1 < 5; inc1++) {
        if (temp1 == int(bullet[inc1][0]) && temp2 == int(bullet[inc1][1])
            || temp1 == int(bullet[inc1][0] + bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + bullet[inc1][3])
            || temp1 == int(bullet[inc1][0] + 2 * bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + 2 * bullet[inc1][3])
            || temp1 == int(bullet[inc1][0] + 3 * bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + 3 * bullet[inc1][3])
            || temp1 == int(bullet[inc1][0] + 4 * bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + 4 * bullet[inc1][3])
            || temp1 == int(bullet[inc1][0] + 5 * bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + 5 * bullet[inc1][3])
            || temp1 == int(bullet[inc1][0] + 6 * bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + 6 * bullet[inc1][3])
            || temp1 == int(bullet[inc1][0] + 7 * bullet[inc1][2])
            && temp2 == int(bullet[inc1][1] + 7 * bullet[inc1][3])) {
            return 1;
        // this function allows a much simpler way to check
        // if an area of space contains a bullet for rendering purposes
        }
    }
    return 0;
    // 0 is returned if no bullets are present
}

bool Spaceship::check_hitbox(int target_x, int target_y, int radius) {
    float distance_x, distance_y;
    
    for (int inc = 0; inc < 5; inc++) {
        distance_x = bullet[inc][0] - target_x;
        distance_y = bullet[inc][1] - target_y;
        // above converts absolute position to relative distance
        
        if (sqrt(distance_x * distance_x + distance_y * distance_y) < radius) {
            // calculates if the distance is short enough
            // to the centre of a target for a hit
            
            bullet[inc][0] += 60 * bullet[inc][2];//bullets that land on target
            bullet[inc][1] += 60 * bullet[inc][3];//are moved out of the screen
            return 1;
        }
    }
    return 0;
    // return a 0 when no hits are detected
}