/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name:Matis Requis
Username:el18mrjr
Student ID Number:201241242
Date:20/04/20
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "TempestEngine.h"


// objects
Gamepad pad;
N5110 lcd;
TempestEngine tempest;

//Objects
void init();
void render();
void welcome();


int main()
{
    while(1) {    
        int fps = 6;
        //initialise and show welcome menu
        init();
        welcome();
        render();
        wait(1.0f/fps);
    
        while (1) {
            tempest.read_input(pad);
            tempest.update();
            render();
            wait(1.0f/fps);
            
            if (tempest.game_over() == 1) {
                lcd.clear();
                lcd.printString("  Game Over!  ",0,1);  
                lcd.printString("  Press Reset ",0,4);
                lcd.refresh();
                wait(1);
                while ( pad.A_pressed() == false) {
                    wait(0.1);    
                }
                break;
            }
        }
    }
}

//initialises everything needed
void init() {
    lcd.init();
    pad.init();
    tempest.init();
    
}

//game loop
void render() {
    lcd.clear();
    tempest.draw(lcd);
    lcd.refresh();   
}

//welcome screen
void welcome() {
    
    lcd.printString("   Tempest!   ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    while ( pad.start_pressed() == false) {
        wait(0.1);
    }
}