#ifndef TEMPESTENGINE_H
#define TEMPESTENGINE_H

// Included Libraries
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bullet.h"
#include "Hero.h"
#include "Board.h"
#include "Alien.h"

#include <vector>
#include <cstdlib>
#include <ctime>

/** TempestEngine Class
 * @brief Interacts all the other classes together and builds the game
 * @author Matis Requis
 * @date May, 2020
 */
class TempestEngine {

public:

    /** Constructor */
    TempestEngine();
    
    /** Destructor */
    ~TempestEngine();
    
    
//GAME FUNCTIONS
    /** Initialises the GameEngine*/
    void init();
    
    /** Reads the input of the board
     * @param pad @details gamepad object
     */
    void read_input(Gamepad &pad);
    
    /** Draws the game using functions from other classes
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    /** Updates the game */
    void update();
    
    
//CLASS INTERACTION FUNCTIONS
    
    /** Displays the score
     * @param lcd @details N5110 object
     */
    void display_score(N5110 &lcd);
    
    /** Displays the amount of lives left
     * @param lcd @details N5110 object
     */
    void display_lives(N5110 &lcd);
    
    /** Checks for collision between an alien and a bullet */
    void check_alien_bullet_colision();
    
    /** Checks if the player is out of lives
     * @return 0 or 1 @details returns 1 if the player is out of lives, otherwise 0
     */
    int game_over();

    
//BULLET FUNCTIONS

    /** Creates new bullets when A is pressed */
    void create_bullets();
    
    /** Iterates through the bullets and draws them
     * @param lcd @details N5110 object
     */
    void draw_bullets(N5110 &lcd);
    
    /** Updates all the bullets positions and removes them once they have reached the bottom */
    void update_bullets();
    
//ALIEN FUNCTIONS

    /** Spawns new aliens randomly every 15-25 frames */
    void create_aliens();
    
    /** Draws all the created aliens
     * @param lcd @details N5110 object
     */
    void draw_aliens(N5110 &lcd);
    
    /** Updates all the aliens positions and removes them when they have reached the top of the board */
    void update_aliens();
    
    
/////////////////VECTOR/////////////////

    /** Stores all the bullets created */
    std::vector<Bullet> bullet_vect;
    
    /** Stores all the aliens spawned */
    std::vector<Alien> alien_vect;
    
private:
    //////////////////OBJECTS////////////////////
    
    /** Board object */
    Board _board;
    
    /** Hero object */
    Hero _hero;
    
    /////////////////VARIABLES////////////////
    int _shooting_speed;
    float _d;
    int _a;
    int _bullet_countdown;
    int _alien_timer;
    int _alienspeed;
    int _score;
    int _herolives;
    

};

#endif