#include "TempestEngine.h"

TempestEngine::TempestEngine() {
    
}

TempestEngine::~TempestEngine() {
    
}

//initialises all the speeds, score, lives, and the hero
void TempestEngine::init() {
    _hero.init(0);
    _alienspeed = 6;
    _score = 0;
    _herolives = 3;
    _shooting_speed = 5;
    }
    
//draws all the elemnts
void TempestEngine::draw(N5110 &lcd) {
    _board.draw(lcd);
    
    //draw hero ship
    _hero.draw(lcd);
    
    //draw bullets
    draw_bullets(lcd);
    
    draw_aliens(lcd);
    display_score(lcd);
    display_lives(lcd);
}
    
 //reads the input from the gamepad   
void TempestEngine::read_input(Gamepad &pad) {
    _d = pad.get_angle();
    _a = pad.A_pressed();  
}


//updates all the objects and members
void TempestEngine::update() {
    _hero.update(_d);
    create_aliens();
    update_aliens();
    create_bullets();
    update_bullets();
    
    check_alien_bullet_colision();
    game_over();
}

//sets the gamover flag to 1 when there are no lives left
int TempestEngine::game_over() {
    if (_herolives == 0) {
        return 1;
    }   else {
        return 0;
    }
}

//displays the amount of lives with three hearts
void TempestEngine::display_lives(N5110 &lcd) {
    
    //heart sprite made with an array
    int heart_sprite[9][9] = { {0,1,1,0,0,0,1,1,0}, {1,1,1,1,0,1,1,1,1}, {1,1,1,1,1,1,1,1,1}, {1,1,1,1,1,1,1,1,1}, {1,1,1,1,1,1,1,1,1}, {0,1,1,1,1,1,1,1,0}, {0,0,1,1,1,1,1,0,0}, {0,0,0,1,1,1,0,0,0}, {0,0,0,0,1,0,0,0,0} };
    
    //displays the amount of hearts corresponding to the amount of lives left
    if (_herolives == 3) {
        lcd.drawSprite(6, 34, 9, 9, (int*)heart_sprite);
        lcd.drawSprite(6, 18, 9, 9, (int*)heart_sprite);
        lcd.drawSprite(6, 3, 9, 9, (int*)heart_sprite);
        
    } else if (_herolives == 2) {
        lcd.drawSprite(6, 34, 9, 9, (int*)heart_sprite);
        lcd.drawSprite(6, 18, 9, 9, (int*)heart_sprite);
        
    } else if (_herolives == 1) {
        lcd.drawSprite(6, 34, 9, 9, (int*)heart_sprite);
        
    }
}

//displays the current score
void TempestEngine::display_score(N5110 &lcd) {
    char buffer[2];
    sprintf(buffer, "%2d", _score);
    lcd.printString(buffer,71,3);
}


void TempestEngine::check_alien_bullet_colision() {
    
    //iterates throught the alien vector
    for (int i = 0; i< alien_vect.size(); i++) {
        
        //gets the current alien column and position in the column
        Vector2D alien_pos = alien_vect[i].getcolumnpos();
        
        //iterates through the bullet vector
        for (int j = 0; j< bullet_vect.size(); j++) {
            
            //gets the current bullet position
            Vector2D bullet_pos = bullet_vect[j].getcolumnpos();
            
            //removes the bullet and the alien if they are on the same position
            if ( (alien_pos.x == bullet_pos.x) && (alien_pos.y <= bullet_pos.y) ) {
                alien_vect.erase(alien_vect.begin() + i);
                bullet_vect.erase(bullet_vect.begin() + j);
                _score++;
            }
        }
    }
} 




////////////////////////////////////////////////////////////BULLET BEHAVIOR/////////////////////////////
void TempestEngine::create_bullets() {
    
    //bullet countdown timer to prevent spam of bullets
    if (_bullet_countdown <= 0) {
        
        //checks if A button is pressed
        if (_a) {
            
            //creates new bullet object and adds it to the bullet vector. 
            Bullet new_bullet;
            
            new_bullet.init(_hero.get_column());
            
            bullet_vect.push_back(new_bullet);
            
            //reset antispam counter
            _bullet_countdown = _shooting_speed;  
        }
    }  
    _bullet_countdown--;
}


//draws all the bullets
void TempestEngine::draw_bullets(N5110 &lcd) {
    //iterates through the bullet objects
    for (int i = 0; i< bullet_vect.size(); i++) {  
        //draws current bullet
        bullet_vect[i].draw(lcd);
    }
}


void TempestEngine::update_bullets() {
    
    //iterates through the bullets
    for (int i =0; i< bullet_vect.size(); i++) {
        bullet_vect[i].update();
        
        //checks if bullet needs to be deleted
        if (bullet_vect[i].checkdelete()) {
            //removes the bullet from the vector 
            bullet_vect.erase(bullet_vect.begin() + i);
        }
    }  
} 




///////////////////////////////////////////////////////////////ALIEN BEHAVIOR//////////////////////////////

void TempestEngine::create_aliens() {
    //alien countdown timer to limit the amount of aliens on screen
    if (_alien_timer <= 0) {
        
        //creates new alien object and adds it to the alien vector. 
        Alien new_alien;
            
        new_alien.init((rand() % 12), _alienspeed);
            
        alien_vect.push_back(new_alien);
        
        //randomises the alien spawn time
        _alien_timer = (rand() % 20) + 15;  
        
    }  
    _alien_timer--;
}


//draws all the aliens
void TempestEngine::draw_aliens(N5110 &lcd) {
    //iterates through the alien objects
    for (int i = 0; i< alien_vect.size(); i++) {  
        //draws current alien
        alien_vect[i].draw(lcd);
    }
}


void TempestEngine::update_aliens() {
    
    //iterates through the all the aliens and updates them
    for (int i =0; i< alien_vect.size(); i++) {
        alien_vect[i].update();
        
        //checks if alien needs to be deleted at the top of the board
        if (alien_vect[i].checkdelete()) {
            
            //removes the alien from the vector and removes a life
            alien_vect.erase(alien_vect.begin() + i);
            _herolives--;
        }
    }  
} 

