#ifndef HERO_H
#define HERO_H

// Included Libraries
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


/** Hero Class
 * @brief Draws and moves the hero
 * @author Matis Requis
 * @date May, 2020
 */
class Hero {
    
public:
    /** Constructor */
    Hero();
    
    /** Destructor */
    ~Hero();
    
    /** Initialises the hero
     * @param column @details the column the hero is going to spawn at
     */
    void init(int column);
    
    /** Draws the hero spaceship
     * @param lcd @details N5110 object
     */
    void draw(N5110 &lcd);
    
    /** Update spaceship position depending on joystick input
     * @param d @details Direction of joystick
     */
    void update(float d);
    
    /** Gets the current position of the hero
     * @return hero_pos @details returns Vector2D structure with xy position
     */
    Vector2D getxy();
    
    /** Gets the current column of the hero
     * @return _column @details returns the current column
     */
    int get_column();
    
private:
    
    
    int _x;
    int _y;
    int _d;
    int _column;
    
};
#endif